/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class SystemUtils {
    private static final Log LOG;
    private static final boolean isLoaded;
    private static boolean supportsIdleTime;

    private SystemUtils() {
    }

    public static long getIdleTime() {
        if (SystemUtils.supportsIdleTime()) {
            return SystemUtils.idleTime();
        }
        return 0L;
    }

    public static boolean supportsIdleTime() {
        if (supportsIdleTime && isLoaded) {
            if (OSUtils.isGoodWindows()) {
                return true;
            }
            if (OSUtils.isMacOSX()) {
                return true;
            }
        }
        return false;
    }

    public static long setOpenFileLimit(int max) {
        if (isLoaded && OSUtils.isMacOSX()) {
            return SystemUtils.setOpenFileLimit0(max);
        }
        return -1L;
    }

    static void setWriteable(String fileName) {
        if (isLoaded && (OSUtils.isWindows() || OSUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(fileName);
        }
    }

    private static native int setOpenFileLimit0(int var0);

    public static String getRunningPath() {
        if (OSUtils.isWindows() && isLoaded) {
            String path = SystemUtils.getRunningPathNative();
            if (path.equals("")) {
                return null;
            }
            return path;
        }
        return null;
    }

    public static String getSpecialPath(SpecialLocations location) {
        if (OSUtils.isWindows()) {
            if (location == SpecialLocations.HOME) {
                return CommonUtils.getUserHomeDir().getPath();
            }
            if (isLoaded) {
                try {
                    String path = SystemUtils.getSpecialPathNative(location.getName());
                    if (!path.equals("")) {
                        return path;
                    }
                    return null;
                }
                catch (UnsatisfiedLinkError error) {
                    LOG.error("Unable to use getSpecialPath!", error);
                    return null;
                }
            }
            return null;
        }
        if (OSUtils.isPOSIX()) {
            if (location == SpecialLocations.HOME) {
                return CommonUtils.getUserHomeDir().getPath();
            }
            if (location == SpecialLocations.DOCUMENTS) {
                return new File(CommonUtils.getUserHomeDir(), location.getName()).getPath();
            }
            if (location == SpecialLocations.DESKTOP) {
                return new File(CommonUtils.getUserHomeDir(), location.getName()).getPath();
            }
            return null;
        }
        return null;
    }

    public static boolean setWindowIcon(Component frame, File icon) {
        if (OSUtils.isWindows() && isLoaded) {
            String result = SystemUtils.setWindowIconNative(frame, System.getProperty("sun.boot.library.path"), icon.getPath());
            return result.equals("");
        }
        return false;
    }

    public static boolean setWindowTopMost(Component frame) {
        if (isLoaded && OSUtils.isWindows()) {
            String result = SystemUtils.setWindowTopMostNative(frame, System.getProperty("sun.boot.library.path"));
            return result.equals("");
        }
        return false;
    }

    public static boolean flushIconCache() {
        if (isLoaded && OSUtils.isWindows()) {
            return SystemUtils.flushIconCacheNative();
        }
        return false;
    }

    public static int registryReadNumber(String root, String path, String name) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryReadNumberNative(root, path, name);
        }
        throw new IOException(" not supported ");
    }

    public static String registryReadText(String root, String path, String name) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryReadTextNative(root, path, name);
        }
        throw new IOException(" not supported ");
    }

    public static boolean registryWriteNumber(String root, String path, String name, int value) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryWriteNumberNative(root, path, name, value);
        }
        return false;
    }

    public static boolean registryWriteText(String root, String path, String name, String value) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryWriteTextNative(root, path, name, value);
        }
        return false;
    }

    public static boolean registryDelete(String root, String path) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryDeleteNative(root, path);
        }
        return false;
    }

    public static boolean isFirewallPresent() {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallPresentNative();
        }
        return false;
    }

    public static boolean isFirewallEnabled() {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallEnabledNative();
        }
        return false;
    }

    public static boolean isFirewallExceptionsNotAllowed() {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallExceptionsNotAllowedNative();
        }
        return false;
    }

    public static boolean isProgramListedOnFirewall(String path) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramListedNative(path);
        }
        return false;
    }

    public static boolean isProgramEnabledOnFirewall(String path) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramEnabledNative(path);
        }
        return false;
    }

    public static boolean addProgramToFirewall(String path, String name) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallAddNative(path, name);
        }
        return false;
    }

    public static boolean removeProgramFromFirewall(String path) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallRemoveNative(path);
        }
        return false;
    }

    public static int openURL(String url) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openURLNative(url);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String path) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileNative(path);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String path, String params) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileParamsNative(path, params);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static boolean recycle(File file) {
        if (OSUtils.isWindows() && isLoaded) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException err) {
                LOG.error("IOException", err);
                path = file.getAbsolutePath();
            }
            return SystemUtils.recycleNative(path);
        }
        return false;
    }

    public static String getDefaultExtentionHandler(String extention) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        if (!extention.startsWith(".")) {
            extention = "." + extention;
        }
        try {
            String progId = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", extention, "");
            if ("".equals(progId)) {
                return "";
            }
            return SystemUtils.registryReadText("HKEY_CLASSES_ROOT", progId + "\\shell\\open\\command", "");
        }
        catch (IOException iox) {
            return null;
        }
    }

    public static String getDefaultMimeHandler(String mimeType) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        String extention = "";
        try {
            extention = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", "MIME\\Database\\Content Type\\" + mimeType, "Extension");
        }
        catch (IOException iox) {
            return null;
        }
        if ("".equals(extention)) {
            return "";
        }
        return SystemUtils.getDefaultExtentionHandler(extention);
    }

    private static native String getRunningPathNative();

    private static native String getSpecialPathNative(String var0);

    private static native void openURLNative(String var0);

    private static native void openFileNative(String var0);

    private static native void openFileParamsNative(String var0, String var1);

    private static native boolean recycleNative(String var0);

    private static native int setFileWriteable(String var0);

    private static native long idleTime();

    private static native String setWindowIconNative(Component var0, String var1, String var2);

    private static native String setWindowTopMostNative(Component var0, String var1);

    private static native boolean flushIconCacheNative();

    private static native int registryReadNumberNative(String var0, String var1, String var2) throws IOException;

    private static native String registryReadTextNative(String var0, String var1, String var2) throws IOException;

    private static native boolean registryWriteNumberNative(String var0, String var1, String var2, int var3);

    private static native boolean registryWriteTextNative(String var0, String var1, String var2, String var3);

    private static native boolean registryDeleteNative(String var0, String var1);

    private static native boolean firewallPresentNative();

    private static native boolean firewallEnabledNative();

    private static native boolean firewallExceptionsNotAllowedNative();

    private static native boolean firewallIsProgramListedNative(String var0);

    private static native boolean firewallIsProgramEnabledNative(String var0);

    private static native boolean firewallAddNative(String var0, String var1);

    private static native boolean firewallRemoveNative(String var0);

    static {
        boolean canLoad;
        LOG = LogFactory.getLog(SystemUtils.class);
        supportsIdleTime = true;
        try {
            if (OSUtils.isWindows()) {
                if (OSUtils.isGoodWindows()) {
                    System.loadLibrary("SystemUtilities");
                } else {
                    System.loadLibrary("SystemUtilitiesA");
                }
            } else if (OSUtils.isMacOSX()) {
                System.loadLibrary("SystemUtilities");
            }
            canLoad = true;
        }
        catch (UnsatisfiedLinkError noGo) {
            canLoad = false;
        }
        isLoaded = canLoad;
    }

    public static enum SpecialLocations {
        HOME("Home"),
        DOCUMENTS("Documents"),
        APPLICATION_DATA("ApplicationData"),
        DESKTOP("Desktop"),
        START_MENU("StartMenu"),
        START_MENU_PROGRAMS("StartMenuPrograms"),
        START_MENU_STARTUP("StartMenuStartup");

        private final String name;

        private SpecialLocations(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SpecialLocations parse(String name) {
            for (SpecialLocations location : SpecialLocations.values()) {
                if (!location.getName().equals(name)) continue;
                return location;
            }
            return null;
        }
    }
}

