/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.features;

import org.jivesoftware.smack.XMPPConnection;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.RosterEvent;
import org.limewire.friend.api.feature.FeatureInitializer;
import org.limewire.friend.api.feature.FeatureRegistry;
import org.limewire.friend.impl.feature.NoSaveFeature;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.xmpp.client.impl.XMPPFriendConnectionImpl;
import org.limewire.xmpp.client.impl.messages.nosave.NoSaveIQ;
import org.limewire.xmpp.client.impl.messages.nosave.NoSaveIQListener;

public class NoSaveFeatureInitializer
implements FeatureInitializer {
    private static final Log LOG = LogFactory.getLog(NoSaveFeatureInitializer.class);
    private final XMPPFriendConnectionImpl connection;
    private final XMPPConnection jabberConnection;
    private final ListenerSupport<RosterEvent> rosterSupport;
    private final ListenerSupport<FriendPresenceEvent> friendPresenceSupport;
    private RosterListener rosterListener;
    private NoSaveIQListener noSaveListener;
    private boolean isRosterReceived;
    private boolean isFeatureSupported;

    public NoSaveFeatureInitializer(XMPPConnection jabberConnection, XMPPFriendConnectionImpl limeConnection, ListenerSupport<RosterEvent> rosterSupport, ListenerSupport<FriendPresenceEvent> friendPresenceSupport) {
        this.connection = limeConnection;
        this.jabberConnection = jabberConnection;
        this.rosterSupport = rosterSupport;
        this.friendPresenceSupport = friendPresenceSupport;
        this.rosterListener = new RosterListener();
        this.noSaveListener = null;
    }

    @Override
    public void register(FeatureRegistry registry) {
        this.rosterSupport.addListener(this.rosterListener);
        registry.registerPrivateInitializer(NoSaveFeature.ID, this);
    }

    @Override
    public void initializeFeature(FriendPresence notUsedInFeatureInit) {
        this.setFeatureSupported(true);
        this.sendNoSaveRequest();
    }

    @Override
    public void removeFeature(FriendPresence friendPresence) {
        friendPresence.removeFeature(NoSaveFeature.ID);
    }

    public void cleanup() {
        this.rosterSupport.removeListener(this.rosterListener);
        if (this.noSaveListener != null) {
            this.jabberConnection.removePacketListener(this.noSaveListener);
            this.noSaveListener.cleanup();
        }
    }

    private void sendNoSaveRequest() {
        if (this.canSendNoSaveRequest()) {
            if (this.noSaveListener == null) {
                this.noSaveListener = NoSaveIQListener.createNoSaveIQListener(this.connection, this.friendPresenceSupport);
                this.jabberConnection.addPacketListener(this.noSaveListener, this.noSaveListener.getPacketFilter());
            }
            NoSaveIQ requestNoSaveSettingsPacket = NoSaveIQ.getNoSaveStatesMessage();
            try {
                this.connection.sendPacket(requestNoSaveSettingsPacket);
            }
            catch (FriendException e) {
                LOG.warn("couldn't request google:nosave settings", e);
            }
        }
    }

    private synchronized void setFeatureSupported(boolean isFeatureSupported) {
        this.isFeatureSupported = isFeatureSupported;
    }

    private synchronized void setRosterReceived(boolean isRosterReceived) {
        this.isRosterReceived = isRosterReceived;
    }

    private synchronized boolean canSendNoSaveRequest() {
        return this.isFeatureSupported && this.isRosterReceived;
    }

    private class RosterListener
    implements EventListener<RosterEvent> {
        private RosterListener() {
        }

        @Override
        @BlockingEvent
        public void handleEvent(RosterEvent event) {
            NoSaveFeatureInitializer.this.setRosterReceived(true);
            NoSaveFeatureInitializer.this.sendNoSaveRequest();
        }
    }
}

