/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.messages.nosave;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.limewire.friend.impl.feature.NoSave;
import org.limewire.util.Objects;
import org.limewire.xmpp.client.impl.messages.InvalidIQException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NoSaveIQ
extends IQ {
    private final Map<String, NoSave> items = new HashMap<String, NoSave>();
    public static final String ELEMENT_NAME = "query";
    public static final String NAME_SPACE = "google:nosave";

    NoSaveIQ(XmlPullParser parser) throws IOException, XmlPullParserException, InvalidIQException {
        do {
            int eventType;
            if ((eventType = parser.getEventType()) == 2) {
                if (parser.getName().equals(ELEMENT_NAME) || !parser.getName().equals("item")) continue;
                String jid = parser.getAttributeValue(null, "jid");
                if (jid == null) {
                    throw new InvalidIQException("no jid value");
                }
                String value = parser.getAttributeValue(null, "value");
                if (value == null) {
                    throw new InvalidIQException("no value in value attribute");
                }
                this.items.put(jid, value.equals(NoSave.ENABLED.getPacketIdentifier()) ? NoSave.ENABLED : NoSave.DISABLED);
                continue;
            }
            if (eventType == 3 && parser.getName().equals(ELEMENT_NAME)) break;
        } while (parser.nextTag() != 1);
    }

    private NoSaveIQ(String jid, NoSave value) {
        this.items.put(Objects.nonNull(jid, "jid"), value);
    }

    private NoSaveIQ() {
    }

    public static NoSaveIQ getNoSaveSetMessage(String userId, NoSave value) {
        NoSaveIQ setMsg = new NoSaveIQ(userId, value);
        setMsg.setType(IQ.Type.SET);
        return setMsg;
    }

    public static NoSaveIQ getNoSaveStatesMessage() {
        return new NoSaveIQ();
    }

    public Map<String, NoSave> getNoSaveUsers() {
        return Collections.unmodifiableMap(this.items);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder s = new StringBuilder("<query xmlns='google:nosave'>");
        for (Map.Entry<String, NoSave> entry : this.items.entrySet()) {
            s.append("<item xmlns='google:nosave' jid='").append(entry.getKey()).append("' value='").append(entry.getValue().getPacketIdentifier()).append("'/>");
        }
        s.append("</query>");
        return s.toString();
    }

    public static IQProvider getIQProvider() {
        return new NoSaveIQProvider();
    }

    private static class NoSaveIQProvider
    implements IQProvider {
        private NoSaveIQProvider() {
        }

        @Override
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            try {
                return new NoSaveIQ(parser);
            }
            catch (InvalidIQException iie) {
                return null;
            }
        }
    }
}

