/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaConfig;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.common.Platform;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.EventBuffer;
import org.mozilla.browser.impl.FocusWatcher;
import org.mozilla.browser.impl.jna.Gdk;
import org.mozilla.browser.impl.jna.Gtk;
import org.mozilla.browser.impl.jna.X11;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMHTMLAnchorElement;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserFocus;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class MozillaCanvas
extends Canvas {
    private static final long serialVersionUID = 2946773219993586110L;
    static Log log = LogFactory.getLog(MozillaCanvas.class);
    private ChromeAdapter chromeAdapter;
    private long mozHandle = 0L;
    private Gtk.GtkWindow gtkPtr = null;
    private CanvasListener canvasListener;
    private WindowListener windowListener;
    private EventBuffer eventBuffer = new EventBuffer();
    private final MozMouseListener ml = new MozMouseListener();
    Component lastFocusedCmp = null;

    public long createHandle(Rectangle dim) {
        assert (MozillaExecutor.isMozillaThread());
        Mozilla moz = Mozilla.getInstance();
        if (Platform.usingGTK2Toolkit()) {
            Toolkit.getDefaultToolkit().sync();
            X11.Window awtID = new X11.Window((int)moz.getNativeHandleFromAWT(this));
            assert (!awtID.isNull());
            if (Platform.platform == Platform.Solaris) {
                this.gtkPtr = Gtk.gtk.gtk_window_new(1);
                Gtk.gtk.gtk_window_set_default_size(this.gtkPtr, 300, 300);
                Gtk.gtk.gtk_window_set_title(this.gtkPtr, "Mozilla Wrapper Window");
            } else {
                this.gtkPtr = Gtk.gtk.gtk_plug_new(awtID);
            }
            assert (this.gtkPtr != null);
            Toolkit.getDefaultToolkit().sync();
            Gtk.gtk.gtk_widget_set_usize(this.gtkPtr, dim.width, dim.height);
            Gtk.gtk.gtk_widget_show(this.gtkPtr);
            Toolkit.getDefaultToolkit().sync();
            if (Platform.platform == Platform.Solaris) {
                X11.Window gtkID = Gtk.gtk.gdk_x11_drawable_get_xid(this.gtkPtr.window);
                Gdk.GdkDisplay display = Gtk.gtk.gdk_display_get_default();
                X11.Display xdisplay = Gtk.gtk.gdk_x11_display_get_xdisplay(display);
                X11.INSTANCE.XReparentWindow(xdisplay, gtkID, awtID, 0, 0);
            }
            this.mozHandle = this.gtkPtr.getPeer();
        } else {
            long h = moz.getNativeHandleFromAWT(this);
            assert (h != 0L);
            this.mozHandle = h;
        }
        return this.mozHandle;
    }

    public void destroyHandle() {
        assert (MozillaExecutor.isMozillaThread());
        if (Platform.usingGTK2Toolkit()) {
            Gtk.gtk.gtk_widget_destroy(this.gtkPtr);
            this.gtkPtr = null;
        }
        this.mozHandle = 0L;
    }

    public long getHandle() {
        return this.mozHandle;
    }

    public void addNotify() {
        log.trace("addNotify");
        super.addNotify();
        this.canvasListener = new CanvasListener();
        this.addComponentListener(this.canvasListener);
        Window win = SwingUtilities.getWindowAncestor(this);
        assert (win != null);
        this.windowListener = new WindowListener(win);
        win.addComponentListener(this.windowListener);
        win.addWindowFocusListener(this.windowListener);
        win.addWindowListener(this.windowListener);
        this.setFocusable(true);
    }

    public void removeNotify() {
        log.trace("removeNotify");
        if (this.canvasListener != null) {
            this.removeComponentListener(this.canvasListener);
            this.canvasListener = null;
        }
        if (this.windowListener != null) {
            this.windowListener.win.removeComponentListener(this.windowListener);
            this.windowListener.win.removeWindowFocusListener(this.windowListener);
            this.windowListener.win.removeWindowListener(this.windowListener);
            this.windowListener = null;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (MozillaCanvas.this.chromeAdapter == null) {
                    return;
                }
                MozillaCanvas.this.chromeAdapter.destroyBrowserWindow();
            }
        };
        MozillaExecutor.mozAsyncExec(r);
        super.removeNotify();
    }

    private void onShow() {
        log.trace("onShow");
        if (this.chromeAdapter == null) {
            this.eventBuffer.record("onShow");
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (MozillaCanvas.this.chromeAdapter == null) {
                    MozillaCanvas.this.eventBuffer.record("onShow");
                    return;
                }
                nsIBaseWindow baseWindow = XPCOMUtils.qi(MozillaCanvas.this.chromeAdapter.getWebBrowser(), nsIBaseWindow.class);
                baseWindow.setVisibility(true);
            }
        };
        MozillaExecutor.mozAsyncExec(r);
    }

    private void onHide() {
        log.trace("onHide");
        if (this.chromeAdapter == null) {
            this.eventBuffer.record("onHide");
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (MozillaCanvas.this.chromeAdapter == null) {
                    MozillaCanvas.this.eventBuffer.record("onHide");
                    return;
                }
                nsIBaseWindow baseWindow = XPCOMUtils.qi(MozillaCanvas.this.chromeAdapter.getWebBrowser(), nsIBaseWindow.class);
                baseWindow.setVisibility(false);
            }
        };
        MozillaExecutor.mozAsyncExec(r);
    }

    private void onResize() {
        log.trace("onResize");
        if (this.chromeAdapter == null) {
            this.eventBuffer.record("onResize");
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                Rectangle rect = MozillaCanvas.this.getBounds();
                if (rect.isEmpty()) {
                    return;
                }
                if (MozillaCanvas.this.chromeAdapter == null) {
                    MozillaCanvas.this.eventBuffer.record("onResize");
                    return;
                }
                nsIBaseWindow baseWindow = XPCOMUtils.qi(MozillaCanvas.this.chromeAdapter.getWebBrowser(), nsIBaseWindow.class);
                baseWindow.setPositionAndSize(rect.x, rect.y, rect.width, rect.height, true);
                if (Platform.usingGTK2Toolkit() && MozillaCanvas.this.gtkPtr != null) {
                    Gtk.gtk.gdk_window_resize(((MozillaCanvas)MozillaCanvas.this).gtkPtr.window, rect.width, rect.height);
                }
            }
        };
        MozillaExecutor.mozAsyncExec(r);
    }

    public void onAttachBrowser(ChromeAdapter chromeAdapter) {
        assert (chromeAdapter != null);
        assert (this.chromeAdapter == null);
        this.chromeAdapter = chromeAdapter;
        if (this.hasFocus()) {
            this.onFocusMovedTo(this);
        }
        nsIWebBrowser brow = chromeAdapter.getWebBrowser();
        nsIDOMWindow2 win = XPCOMUtils.qi(brow.getContentDOMWindow(), nsIDOMWindow2.class);
        nsIDOMEventTarget et = win.getWindowRoot();
        et.addEventListener("mousedown", this.ml, false);
        FocusWatcher.register(this);
        if (!MozillaConfig.isEnabledImages()) {
            MozillaConfig.disableImages(chromeAdapter.getPanel());
        }
        boolean vis = this.isVisible();
        nsIBaseWindow baseWindow = XPCOMUtils.qi(chromeAdapter.getWebBrowser(), nsIBaseWindow.class);
        baseWindow.setVisibility(vis);
        this.eventBuffer.replayOn(this);
    }

    public void onDetachBrowser() {
        nsIWebBrowser brow = this.chromeAdapter.getWebBrowser();
        nsIDOMWindow2 win = XPCOMUtils.qi(brow.getContentDOMWindow(), nsIDOMWindow2.class);
        nsIDOMEventTarget et = win.getWindowRoot();
        et.removeEventListener("mousedown", this.ml, false);
        FocusWatcher.unregister(this);
        this.chromeAdapter = null;
    }

    public void onFocusMovedTo(Component cmp) {
        if (cmp == this.lastFocusedCmp) {
            return;
        }
        log.debug("focus moved to: " + (this.lastFocusedCmp == null ? null : this.lastFocusedCmp.getClass().getSimpleName()) + " -> " + (cmp == null ? null : cmp.getClass().getSimpleName()));
        if (cmp == this) {
            if (this.lastFocusedCmp != this && this.chromeAdapter != null) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (MozillaCanvas.this.chromeAdapter == null) {
                            return;
                        }
                        nsIWebBrowserFocus webBrowserFocus = XPCOMUtils.qi(MozillaCanvas.this.chromeAdapter.getWebBrowser(), nsIWebBrowserFocus.class);
                        webBrowserFocus.activate();
                        log.debug("-------mozilla activated");
                    }
                };
                MozillaExecutor.mozAsyncExec(r);
            }
        } else if (this.lastFocusedCmp == this && this.chromeAdapter != null) {
            Runnable r = new Runnable(){

                public void run() {
                    if (MozillaCanvas.this.chromeAdapter == null) {
                        return;
                    }
                    nsIWebBrowserFocus webBrowserFocus = XPCOMUtils.qi(MozillaCanvas.this.chromeAdapter.getWebBrowser(), nsIWebBrowserFocus.class);
                    if (Platform.platform == Platform.OSX) {
                        try {
                            log.debug("blurring");
                            nsIDOMElement el = webBrowserFocus.getFocusedElement();
                            log.debug("el=" + el);
                            nsIDOMHTMLAnchorElement ael = XPCOMUtils.qi(el, nsIDOMHTMLAnchorElement.class);
                            if (ael != null) {
                                ael.blur();
                                log.debug("-------link blurred");
                            }
                        }
                        catch (XPCOMException xPCOMException) {
                            // empty catch block
                        }
                    }
                    webBrowserFocus.deactivate();
                    log.debug("-------mozilla deactivated");
                }
            };
            MozillaExecutor.mozAsyncExec(r);
        }
        this.lastFocusedCmp = cmp;
    }

    private class MozMouseListener
    implements nsIDOMEventListener {
        private MozMouseListener() {
        }

        public void handleEvent(nsIDOMEvent ev) {
            log.debug("dom event " + ev.getType());
            MozillaExecutor.swingAsyncExec(new Runnable(){

                public void run() {
                    if (MozillaCanvas.this.lastFocusedCmp != MozillaCanvas.this) {
                        MozillaCanvas.this.requestFocus();
                    }
                }
            });
        }

        public nsISupports queryInterface(String uuid) {
            return Mozilla.queryInterface(this, uuid);
        }
    }

    private class WindowListener
    extends WindowAdapter
    implements ComponentListener,
    WindowFocusListener {
        private final Window win;
        Component lastFocusedCmpOnDeactivate = null;

        public WindowListener(Window win) {
            this.win = win;
        }

        public void componentHidden(ComponentEvent e) {
            MozillaCanvas.this.onHide();
        }

        public void componentShown(ComponentEvent e) {
            MozillaCanvas.this.onShow();
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
            log.debug("window activated, lastWas: " + this.lastFocusedCmpOnDeactivate);
            MozillaCanvas.this.onFocusMovedTo(this.lastFocusedCmpOnDeactivate);
        }

        public void windowDeactivated(WindowEvent e) {
            log.debug("window deactivated");
            this.lastFocusedCmpOnDeactivate = MozillaCanvas.this.lastFocusedCmp;
            MozillaCanvas.this.onFocusMovedTo(null);
        }
    }

    private class CanvasListener
    implements ComponentListener {
        private CanvasListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            MozillaCanvas.this.onResize();
        }

        public void componentMoved(ComponentEvent e) {
        }
    }
}

