/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.concurrent.Semaphore;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.IMozillaWindowFactory;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.DOMAdapter;
import org.mozilla.browser.impl.MozillaContainer;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsIDocShellTreeItem;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIThread;
import org.mozilla.interfaces.nsIThreadManager;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWindowCreator;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class WindowCreator
implements nsIWindowCreator {
    private static IMozillaWindowFactory winFactory = new DefaultWindowFactory();

    public static void setWindowFactory(IMozillaWindowFactory f) {
        winFactory = f;
    }

    public static IMozillaWindowFactory getWindowFactory() {
        return winFactory;
    }

    public nsISupports queryInterface(String aIID) {
        return Mozilla.queryInterface(this, aIID);
    }

    public void ensurePrecreatedWindows(int winNum) {
    }

    public nsIWebBrowserChrome createChromeWindow(nsIWebBrowserChrome parent, long chromeFlags) {
        final Semaphore sem = new Semaphore(2);
        sem.acquireUninterruptibly(2);
        final IMozillaWindow[] newWin = new IMozillaWindow[]{null};
        MozillaExecutor.swingAsyncExec(new Runnable(){

            private IMozillaWindow create() {
                assert (!MozillaExecutor.isMozillaThread());
                if (winFactory == null) {
                    return null;
                }
                IMozillaWindow w = winFactory.create(false);
                if (!(w instanceof Component)) {
                    return null;
                }
                Component c = (Component)((Object)w);
                c.addNotify();
                return w;
            }

            public void run() {
                sem.release();
                newWin[0] = this.create();
                MozillaAutomation.sleep(1000);
                sem.release();
            }
        });
        nsIThreadManager tm = XPCOMUtils.getService("@mozilla.org/thread-manager;1", nsIThreadManager.class);
        nsIThread mt2 = tm.getMainThread();
        while (!sem.tryAcquire(2)) {
            if (!mt2.hasPendingEvents()) continue;
            mt2.processNextEvent(false);
        }
        if (newWin[0] == null) {
            throw new XPCOMException(2147500037L);
        }
        MozillaPanel newPanel = newWin[0].getPanel();
        if (newPanel == null) {
            throw new XPCOMException(2147500037L);
        }
        MozillaContainer newWinContainer = newPanel.getMozillaContainer();
        if (newWinContainer == null) {
            throw new XPCOMException(2147500037L);
        }
        MozillaPanel parentPanel = null;
        if (parent != null) {
            parentPanel = MozillaAutomation.findWindow(parent);
        }
        newPanel.setParentPanel(parentPanel);
        ChromeAdapter newChromeAdapter = WindowCreator.attachBrowser(newPanel, chromeFlags, parentPanel);
        if (newChromeAdapter == null) {
            throw new XPCOMException(2147500037L);
        }
        return newChromeAdapter;
    }

    public static ChromeAdapter attachBrowser(MozillaPanel moz, long chromeFlags, MozillaPanel parentMoz) {
        assert (MozillaExecutor.isMozillaThread());
        MozillaContainer con = moz.getMozillaContainer();
        if (!con.isDisplayable()) {
            return null;
        }
        if (chromeFlags == 1L) {
            chromeFlags = 4094L;
        }
        nsIWebBrowser webBrowser = XPCOMUtils.create("@mozilla.org/embedding/browser/nsWebBrowser;1", nsIWebBrowser.class);
        ChromeAdapter chromeAdapter = new ChromeAdapter(moz, webBrowser, chromeFlags);
        webBrowser.setContainerWindow(chromeAdapter);
        nsIDocShellTreeItem item = XPCOMUtils.qi(webBrowser, nsIDocShellTreeItem.class);
        item.setItemType(chromeAdapter.isChromeWindow() ? 3 : 2);
        Rectangle dim = con.getBounds();
        nsIBaseWindow baseWindow = XPCOMUtils.qi(webBrowser, nsIBaseWindow.class);
        baseWindow.initWindow(con.getMozillaCanvas().createHandle(dim), 0L, 0, 0, dim.width, dim.height);
        baseWindow.create();
        webBrowser.addWebBrowserListener(chromeAdapter.getProgressAdapter(), "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        webBrowser.setParentURIContentListener(chromeAdapter.getContentAdapter());
        nsIDOMWindow2 domWin = XPCOMUtils.qi(webBrowser.getContentDOMWindow(), nsIDOMWindow2.class);
        nsIDOMEventTarget et = domWin.getWindowRoot();
        for (String ev : DOMAdapter.hookedEvents) {
            et.addEventListener(ev, chromeAdapter.getDOMAdapter(), false);
        }
        ChromeAdapter parentChromeAdapter = null;
        if (parentMoz != null) {
            parentChromeAdapter = parentMoz.getChromeAdapter();
        }
        moz.onAttachBrowser(chromeAdapter, parentChromeAdapter);
        return chromeAdapter;
    }

    public static void detachBrowser(MozillaPanel moz) {
        assert (MozillaExecutor.isMozillaThread());
        MozillaContainer con = moz.getMozillaContainer();
        ChromeAdapter chromeAdapter = moz.getChromeAdapter();
        if (chromeAdapter == null) {
            return;
        }
        moz.onDetachBrowser();
        nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
        nsIDOMWindow2 domWin = XPCOMUtils.qi(webBrowser.getContentDOMWindow(), nsIDOMWindow2.class);
        nsIDOMEventTarget et = domWin.getWindowRoot();
        for (String ev : DOMAdapter.hookedEvents) {
            et.removeEventListener(ev, chromeAdapter.getDOMAdapter(), false);
        }
        webBrowser.setParentURIContentListener(null);
        webBrowser.removeWebBrowserListener(chromeAdapter.getProgressAdapter(), "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        nsIBaseWindow baseWindow = XPCOMUtils.qi(webBrowser, nsIBaseWindow.class);
        baseWindow.destroy();
        con.getMozillaCanvas().destroyHandle();
        webBrowser.setContainerWindow(null);
    }

    static class DefaultWindowFactory
    implements IMozillaWindowFactory {
        DefaultWindowFactory() {
        }

        public IMozillaWindow create(boolean attach) {
            MozillaPanel panel = new MozillaPanel(attach);
            return new MozillaWindow(panel);
        }
    }
}

