/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

public class GSMEncoder {
    private static final byte GSM_MAGIC = 13;
    private static final int[] FAC = new int[]{18431, 20479, 22527, 24575, 26623, 28671, 30719, Short.MAX_VALUE};
    private final int[] gsm_DLB = new int[]{6554, 16384, 26214, Short.MAX_VALUE};
    private static final byte[] bitoff = new byte[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] gsm_NRFAC = new int[]{29128, 26215, 23832, 21846, 20165, 18725, 17476, 16384};
    private static final int[] QLB = new int[]{3277, 11469, 21299, Short.MAX_VALUE};
    private static final int MIN_WORD = Short.MIN_VALUE;
    private static final int MAX_WORD = Short.MAX_VALUE;
    private static final int MIN_LONGWORD = Integer.MIN_VALUE;
    private static final int MAX_LONGWORD = Integer.MAX_VALUE;
    private final int[] dp0 = new int[280];
    private final int[] u = new int[8];
    private final int[][] LARpp = new int[2][8];
    private int j;
    private int[] v = new int[9];
    private int msr;
    private final int[] e = new int[50];
    private int z1;
    private int L_z2;
    private int mp;
    private int ltp_cut;
    private char verbose;
    private char fast;
    private char wav_fmt;
    private char frame_index;
    private char frame_chain;
    private int dpOffset;
    private int dppOffset;
    private int bcOffset;
    private int ncOffset;
    private int xmaxcOffset;
    private int eOffset;
    private int xmcOffset;
    private int dOffset;
    private int mcoffset = 0;

    public void GSM() {
        int nrp = 40;
    }

    final int[] encode(int[] s) {
        byte[] c = new byte[33];
        this.encode(c, s);
        return s;
    }

    public final void encode(byte[] c, int[] s) {
        int i = 0;
        int[] LARc = new int[8];
        int[] Nc = new int[4];
        int[] Mc = new int[4];
        int[] bc = new int[4];
        int[] xmaxc = new int[4];
        int[] xmc = new int[52];
        this.encoder(s, LARc, Nc, bc, Mc, xmaxc, xmc);
        c[i++] = (byte)(0xD0 | LARc[0] >> 2 & 0xF);
        c[i++] = (byte)((LARc[0] & 3) << 6 | LARc[1] & 0x3F);
        c[i++] = (byte)((LARc[2] & 0x1F) << 3 | LARc[3] >> 2 & 7);
        c[i++] = (byte)((LARc[3] & 3) << 6 | (LARc[4] & 0xF) << 2 | LARc[5] >> 2 & 3);
        c[i++] = (byte)((LARc[5] & 3) << 6 | (LARc[6] & 7) << 3 | LARc[7] & 7);
        c[i++] = (byte)((Nc[0] & 0x7F) << 1 | bc[0] >>> 1 & 1);
        c[i++] = (byte)((bc[0] & 1) << 7 | (Mc[0] & 3) << 5 | xmaxc[0] >> 1 & 0x1F);
        c[i++] = (byte)((xmaxc[0] & 1) << 7 | (xmc[0] & 7) << 4 | (xmc[1] & 7) << 1 | xmc[2] >> 2 & 1);
        c[i++] = (byte)((xmc[2] & 3) << 6 | (xmc[3] & 7) << 3 | xmc[4] & 7);
        c[i++] = (byte)((xmc[5] & 7) << 5 | (xmc[6] & 7) << 2 | xmc[7] >> 1 & 3);
        c[i++] = (byte)((xmc[7] & 1) << 7 | (xmc[8] & 7) << 4 | (xmc[9] & 7) << 1 | xmc[10] >> 2 & 1);
        c[i++] = (byte)((xmc[10] & 3) << 6 | (xmc[11] & 7) << 3 | xmc[12] & 7);
        c[i++] = (byte)((Nc[1] & 0x7F) << 1 | bc[1] >> 1 & 1);
        c[i++] = (byte)((bc[1] & 1) << 7 | (Mc[1] & 3) << 5 | xmaxc[1] >> 1 & 0x1F);
        c[i++] = (byte)((xmaxc[1] & 1) << 7 | (xmc[13] & 7) << 4 | (xmc[14] & 7) << 1 | xmc[15] >> 2 & 1);
        c[i++] = (byte)((xmc[15] & 3) << 6 | (xmc[16] & 7) << 3 | xmc[17] & 7);
        c[i++] = (byte)((xmc[18] & 7) << 5 | (xmc[19] & 7) << 2 | xmc[20] >> 1 & 3);
        c[i++] = (byte)((xmc[20] & 1) << 7 | (xmc[21] & 7) << 4 | (xmc[22] & 7) << 1 | xmc[23] >> 2 & 1);
        c[i++] = (byte)((xmc[23] & 3) << 6 | (xmc[24] & 7) << 3 | xmc[25] & 7);
        c[i++] = (byte)((Nc[2] & 0x7F) << 1 | bc[2] >> 1 & 1);
        c[i++] = (byte)((bc[2] & 1) << 7 | (Mc[2] & 3) << 5 | xmaxc[2] >> 1 & 0x1F);
        c[i++] = (byte)((xmaxc[2] & 1) << 7 | (xmc[26] & 7) << 4 | (xmc[27] & 7) << 1 | xmc[28] >> 2 & 1);
        c[i++] = (byte)((xmc[28] & 3) << 6 | (xmc[29] & 7) << 3 | xmc[30] & 7);
        c[i++] = (byte)((xmc[31] & 7) << 5 | (xmc[32] & 7) << 2 | xmc[33] >> 1 & 3);
        c[i++] = (byte)((xmc[33] & 1) << 7 | (xmc[34] & 7) << 4 | (xmc[35] & 7) << 1 | xmc[36] >> 2 & 1);
        c[i++] = (byte)((xmc[36] & 3) << 6 | (xmc[37] & 7) << 3 | xmc[38] & 7);
        c[i++] = (byte)((Nc[3] & 0x7F) << 1 | bc[3] >> 1 & 1);
        c[i++] = (byte)((bc[3] & 1) << 7 | (Mc[3] & 3) << 5 | xmaxc[3] >> 1 & 0x1F);
        c[i++] = (byte)((xmaxc[3] & 1) << 7 | (xmc[39] & 7) << 4 | (xmc[40] & 7) << 1 | xmc[41] >> 2 & 1);
        c[i++] = (byte)((xmc[41] & 3) << 6 | (xmc[42] & 7) << 3 | xmc[43] & 7);
        c[i++] = (byte)((xmc[44] & 7) << 5 | (xmc[45] & 7) << 2 | xmc[46] >> 1 & 3);
        c[i++] = (byte)((xmc[46] & 1) << 7 | (xmc[47] & 7) << 4 | (xmc[48] & 7) << 1 | xmc[49] >> 2 & 1);
        c[i++] = (byte)((xmc[49] & 3) << 6 | (xmc[50] & 7) << 3 | xmc[51] & 7);
    }

    private void encoder(int[] s, int[] LARc, int[] nc, int[] bc, int[] mc, int[] xmaxc, int[] xmc) {
        int[] dp = this.dp0;
        int[] dpp = this.dp0;
        int[] so = new int[160];
        this.dpOffset = 120;
        this.dppOffset = 120;
        this.dOffset = 0;
        boolean soOffset = false;
        this.ncOffset = 0;
        this.bcOffset = 0;
        this.eOffset = 0;
        this.xmaxcOffset = 0;
        this.xmcOffset = 0;
        this.mcoffset = 0;
        this.GsmPreprocess(s, so);
        this.GsmLPCAnalysis(so, LARc);
        this.Gsm_Short_Term_Analysis_Filter(LARc, so);
        int k = 0;
        while (k <= 3) {
            this.dOffset = k * 40;
            this.eOffset = 5;
            this.Gsm_Long_Term_Predictor(so, dp, this.e, dpp, nc, bc);
            this.Gsm_RPE_Encoding(this.e, xmaxc, mc, xmc);
            for (int i = 0; i <= 39; ++i) {
                dp[this.dpOffset + i] = GSMEncoder.add(this.e[5 + i], dpp[this.dppOffset + i]);
            }
            this.dpOffset += 40;
            this.dppOffset += 40;
            ++this.ncOffset;
            ++this.bcOffset;
            ++this.xmaxcOffset;
            ++this.mcoffset;
            ++k;
            this.xmcOffset += 13;
        }
        System.arraycopy(this.dp0, 0, this.dp0, 160, 120);
    }

    private void Gsm_RPE_Encoding(int[] e, int[] xmaxc, int[] mc, int[] xmc) {
        int[] x = new int[40];
        int[] xM = new int[13];
        int[] xMp = new int[13];
        int[] mant = new int[1];
        int[] exp = new int[1];
        this.Weighting_filter(e, x);
        this.RPE_grid_selection(x, xM, mc);
        this.APCM_quantization(xM, xmc, mant, exp, xmaxc);
        this.APCMInverseQuantization(xmc, exp[0], mant[0], xMp);
        this.RPE_grid_positioning(mc[this.mcoffset], xMp, e);
    }

    private void APCM_quantization(int[] xM, int[] xMc, int[] mant_out, int[] exp_out, int[] xmaxc_out) {
        int temp;
        int i;
        int[] exp = new int[1];
        int[] mant = new int[1];
        int xmax = 0;
        for (i = 0; i <= 12; ++i) {
            temp = xM[i];
            if ((temp = this.abs(temp)) <= xmax) continue;
            xmax = temp;
        }
        exp[0] = 0;
        temp = this.sasr(xmax, 9);
        boolean itest = false;
        for (i = 0; i <= 5; ++i) {
            itest |= temp <= 0;
            temp = this.sasr(temp, 1);
            assert (exp[0] <= 5);
            if (itest) continue;
            exp[0] = exp[0] + 1;
        }
        assert (exp[0] <= 6 && exp[0] >= 0);
        temp = exp[0] + 5;
        assert (temp <= 11 && temp >= 0);
        int xmaxc = GSMEncoder.add(this.sasr(xmax, temp), exp[0] << 3);
        this.APCM_quantization_xmaxc_to_exp_mant(xmaxc, exp, mant);
        assert (exp[0] <= 4096 && exp[0] >= -4096);
        assert (mant[0] >= 0 && mant[0] <= 7);
        int temp1 = 6 - exp[0];
        int temp2 = this.gsm_NRFAC[mant[0]];
        for (i = 0; i <= 12; ++i) {
            assert (temp1 >= 0 && temp1 < 16);
            temp = xM[i] << temp1;
            temp = this.gsm_mult(temp, temp2);
            temp = this.sasr(temp, 12);
            xMc[this.xmcOffset + i] = temp + 4;
        }
        mant_out[0] = mant[0];
        exp_out[0] = exp[0];
        xmaxc_out[this.xmaxcOffset] = xmaxc;
    }

    private void APCM_quantization_xmaxc_to_exp_mant(int xmaxc, int[] exp_out, int[] mant_out) {
        int mant;
        int exp = 0;
        if (xmaxc > 15) {
            exp = this.sasr(xmaxc, 3) - 1;
        }
        if ((mant = xmaxc - (exp << 3)) == 0) {
            exp = -4;
            mant = 7;
        } else {
            while (mant <= 7) {
                mant = mant << 1 | 1;
                --exp;
            }
            mant -= 8;
        }
        assert (exp >= -4 && exp <= 6);
        assert (mant >= 0 && mant <= 7);
        exp_out[0] = exp;
        mant_out[0] = mant;
    }

    private void RPE_grid_selection(int[] x, int[] xM, int[] Mc_out) {
        int L_temp;
        int j;
        int EM = 0;
        int Mc = 0;
        int L_result = 0;
        for (j = 1; j <= 12; ++j) {
            L_temp = this.sasr(x[3 * j], 2);
            L_result += L_temp * L_temp;
        }
        int L_common_0_3 = L_result;
        L_temp = this.sasr(x[0], 2);
        L_result += L_temp * L_temp;
        EM = L_result <<= 1;
        L_result = 0;
        for (j = 0; j <= 12; ++j) {
            L_temp = this.sasr(x[1 + 3 * j], 2);
            L_result += L_temp * L_temp;
        }
        if ((L_result <<= 1) > EM) {
            Mc = 1;
            EM = L_result;
        }
        L_result = 0;
        for (j = 0; j <= 12; ++j) {
            L_temp = this.sasr(x[2 + 3 * j], 2);
            L_result += L_temp * L_temp;
        }
        if ((L_result <<= 1) > EM) {
            Mc = 2;
            EM = L_result;
        }
        L_result = L_common_0_3;
        L_temp = this.sasr(x[39], 2);
        L_result += L_temp * L_temp;
        if ((L_result <<= 1) > EM) {
            Mc = 3;
            EM = L_result;
        }
        for (int i = 0; i <= 12; ++i) {
            xM[i] = x[Mc + 3 * i];
        }
        Mc_out[this.mcoffset] = Mc;
    }

    private void Weighting_filter(int[] e, int[] x) {
        int ei = this.eOffset - 5;
        for (int k = 0; k <= 39; ++k) {
            int L_result = 4096;
            L_result += e[ei + k] * -134 + e[ei + k + 1] * -374 + e[ei + k + 3] * 2054 + e[ei + k + 4] * 5741 + e[ei + k + 5] * 8192 + e[ei + k + 6] * 5741 + e[ei + k + 7] * 2054 + e[ei + k + 9] * -374 + e[ei + k + 10] * -134;
            x[k] = (L_result = this.sasr(L_result, 13)) < Short.MIN_VALUE ? Short.MIN_VALUE : (L_result > Short.MAX_VALUE ? Short.MAX_VALUE : L_result);
        }
    }

    private void Gsm_Long_Term_Predictor(int[] d, int[] dp, int[] e, int[] dpp, int[] nc, int[] bc) {
        this.Calculation_of_the_LTP_parameters(d, dp, bc, nc);
        this.Long_term_analysis_filtering(bc[this.bcOffset], nc[this.ncOffset], dp, d, dpp, e);
    }

    void Long_term_analysis_filtering(int bc, int nc, int[] dp, int[] d, int[] dpp, int[] e) {
        switch (bc) {
            case 0: {
                for (int k = 0; k <= 39; ++k) {
                    dpp[this.dppOffset + k] = GSMEncoder.mult_r(3277, dp[this.dpOffset + k - nc]);
                    e[this.eOffset + k] = GSMEncoder.sub(d[this.dOffset + k], dpp[this.dppOffset + k]);
                }
                break;
            }
            case 1: {
                for (int k = 0; k <= 39; ++k) {
                    dpp[this.dppOffset + k] = GSMEncoder.mult_r(11469, dp[this.dpOffset + k - nc]);
                    e[this.eOffset + k] = GSMEncoder.sub(d[this.dOffset + k], dpp[this.dppOffset + k]);
                }
                break;
            }
            case 2: {
                for (int k = 0; k <= 39; ++k) {
                    dpp[this.dppOffset + k] = GSMEncoder.mult_r(21299, dp[this.dpOffset + k - nc]);
                    e[this.eOffset + k] = GSMEncoder.sub(d[this.dOffset + k], dpp[this.dppOffset + k]);
                }
                break;
            }
            case 3: {
                for (int k = 0; k <= 39; ++k) {
                    dpp[this.dppOffset + k] = GSMEncoder.mult_r(Short.MAX_VALUE, dp[this.dpOffset + k - nc]);
                    e[this.eOffset + k] = GSMEncoder.sub(d[this.dOffset + k], dpp[this.dppOffset + k]);
                }
                break;
            }
        }
    }

    private void Calculation_of_the_LTP_parameters(int[] d, int[] dp, int[] bc_out, int[] nc_out) {
        int bc;
        int scal;
        int temp;
        int k;
        int[] wt = new int[40];
        int dmax = 0;
        for (k = 0; k < 40; ++k) {
            temp = d[this.dOffset + k];
            if ((temp = this.abs(temp)) <= dmax) continue;
            dmax = temp;
        }
        temp = 0;
        if (dmax == 0) {
            scal = 0;
        } else {
            assert (dmax > 0);
            temp = this.gsm_norm(dmax << 16);
        }
        scal = temp > 6 ? 0 : 6 - temp;
        assert (scal >= 0);
        for (k = 0; k < 40; ++k) {
            wt[k] = this.sasr(d[this.dOffset + k], scal);
        }
        int L_max = 0;
        int Nc = 40;
        for (int lambda = 40; lambda <= 120; ++lambda) {
            int L_result = wt[0] * dp[this.dpOffset - lambda];
            for (int i = 1; i < 40; ++i) {
                L_result += wt[i] * dp[this.dpOffset + i - lambda];
            }
            if (L_result <= L_max) continue;
            Nc = lambda;
            L_max = L_result;
        }
        nc_out[this.ncOffset] = Nc;
        L_max <<= 1;
        assert (scal <= 100 && scal >= -100);
        L_max >>= 6 - scal;
        assert (Nc <= 120 && Nc >= 40);
        int L_power = 0;
        for (k = 0; k <= 39; ++k) {
            int L_temp = this.sasr(dp[this.dpOffset + k - Nc], 3);
            L_power += L_temp * L_temp;
        }
        L_power <<= 1;
        if (L_max <= 0) {
            bc_out[this.bcOffset] = 0;
            return;
        }
        if (L_max >= L_power) {
            bc_out[this.bcOffset] = 3;
            return;
        }
        temp = this.gsm_norm(L_power);
        int R = this.sasr(L_max << temp, 16);
        int S = this.sasr(L_power << temp, 16);
        for (bc = 0; bc <= 2 && R > this.gsm_mult(S, this.gsm_DLB[bc]); ++bc) {
        }
        bc_out[this.bcOffset] = bc;
    }

    private void Gsm_Short_Term_Analysis_Filter(int[] larc, int[] s) {
        int[] LARpp_j = this.LARpp[this.j];
        int[] LARpp_j_1 = this.LARpp[this.j ^= 1];
        int[] larp = new int[8];
        this.DecodingOfTheCodedLogAreaRatios(larc, LARpp_j);
        this.Coefficients_0_12(LARpp_j_1, LARpp_j, larp);
        GSMEncoder.LARp_to_rp(larp);
        this.Short_term_analysis_filtering(larp, 13, s, 0);
        this.Coefficients_13_26(LARpp_j_1, LARpp_j, larp);
        GSMEncoder.LARp_to_rp(larp);
        this.Short_term_analysis_filtering(larp, 14, s, 13);
        this.Coefficients_27_39(LARpp_j_1, LARpp_j, larp);
        GSMEncoder.LARp_to_rp(larp);
        this.Short_term_analysis_filtering(larp, 13, s, 27);
        GSMEncoder.Coefficients_40_159(LARpp_j, larp);
        GSMEncoder.LARp_to_rp(larp);
        this.Short_term_analysis_filtering(larp, 120, s, 40);
    }

    private void Short_term_analysis_filtering(int[] rp, int k_n, int[] s, int offset) {
        int si = offset;
        while (k_n-- > 0) {
            int sav;
            int di = sav = s[si];
            for (int i = 0; i < 8; ++i) {
                int ui = this.u[i];
                int rpi = rp[i];
                this.u[i] = sav;
                int zzz = GSMEncoder.mult_r(rpi, di);
                sav = GSMEncoder.add(ui, zzz);
                zzz = GSMEncoder.mult_r(rpi, ui);
                di = GSMEncoder.add(di, zzz);
            }
            s[si] = di;
            ++si;
        }
    }

    private void DecodingOfTheCodedLogAreaRatios(int[] larc, int[] larpp) {
        int larci = 0;
        int larppi = 0;
        int temp1 = GSMEncoder.add(larc[larci++], -32) << 10;
        temp1 = GSMEncoder.sub(temp1, 0);
        temp1 = GSMEncoder.mult_r(13107, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -32) << 10;
        temp1 = GSMEncoder.sub(temp1, 0);
        temp1 = GSMEncoder.mult_r(13107, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -16) << 10;
        temp1 = GSMEncoder.sub(temp1, 4096);
        temp1 = GSMEncoder.mult_r(13107, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -16) << 10;
        temp1 = GSMEncoder.sub(temp1, -5120);
        temp1 = GSMEncoder.mult_r(13107, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -8) << 10;
        temp1 = GSMEncoder.sub(temp1, 188);
        temp1 = GSMEncoder.mult_r(19223, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -8) << 10;
        temp1 = GSMEncoder.sub(temp1, -3584);
        temp1 = GSMEncoder.mult_r(17476, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -4) << 10;
        temp1 = GSMEncoder.sub(temp1, -682);
        temp1 = GSMEncoder.mult_r(31454, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
        temp1 = GSMEncoder.add(larc[larci++], -4) << 10;
        temp1 = GSMEncoder.sub(temp1, -2288);
        temp1 = GSMEncoder.mult_r(29708, temp1);
        larpp[larppi++] = GSMEncoder.add(temp1, temp1);
    }

    private void GsmLPCAnalysis(int[] s, int[] LARc) {
        int[] L_ACF = new int[9];
        this.Autocorrelation(s, L_ACF);
        this.Reflection_coefficients(L_ACF, LARc);
        this.Transformation_to_Log_Area_Ratios(LARc);
        this.Quantization_and_coding(LARc);
    }

    private void Quantization_and_coding(int[] lar) {
        int lari = 0;
        int temp = this.gsm_mult(20480, lar[lari]);
        temp = GSMEncoder.add(temp, 0);
        temp = GSMEncoder.add(temp, 256);
        lar[lari] = (temp = this.sasr(temp, 9)) > 31 ? 63 : (temp < -32 ? 0 : temp - -32);
        temp = this.gsm_mult(20480, lar[++lari]);
        temp = GSMEncoder.add(temp, 0);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 31 ? 63 : (temp < -32 ? 0 : temp - -32);
        temp = this.gsm_mult(20480, lar[++lari]);
        temp = GSMEncoder.add(temp, 2048);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 15 ? 31 : (temp < -16 ? 0 : temp - -16);
        temp = this.gsm_mult(20480, lar[++lari]);
        temp = GSMEncoder.add(temp, -2560);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 15 ? 31 : (temp < -16 ? 0 : temp - -16);
        temp = this.gsm_mult(13964, lar[++lari]);
        temp = GSMEncoder.add(temp, 94);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 7 ? 15 : (temp < -8 ? 0 : temp - -8);
        temp = this.gsm_mult(15360, lar[++lari]);
        temp = GSMEncoder.add(temp, -1792);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 7 ? 15 : (temp < -8 ? 0 : temp - -8);
        temp = this.gsm_mult(8534, lar[++lari]);
        temp = GSMEncoder.add(temp, -341);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 3 ? 7 : (temp < -4 ? 0 : temp - -4);
        temp = this.gsm_mult(9036, lar[++lari]);
        temp = GSMEncoder.add(temp, -1144);
        temp = GSMEncoder.add(temp, 256);
        temp = this.sasr(temp, 9);
        lar[lari] = temp > 3 ? 7 : (temp < -4 ? 0 : temp - -4);
        ++lari;
    }

    private void Transformation_to_Log_Area_Ratios(int[] r) {
        int ri = 0;
        int i = 1;
        while (i <= 8) {
            int temp = r[ri];
            temp = this.abs(temp);
            assert (temp >= 0);
            if (temp < 22118) {
                temp >>= 1;
            } else if (temp < 31130) {
                assert (temp >= 11059);
                temp -= 11059;
            } else {
                assert (temp >= 26112);
                temp -= 26112;
                temp <<= 2;
            }
            int n = r[ri] = r[ri] < 0 ? -temp : temp;
            assert (r[ri] != Short.MIN_VALUE);
            ++i;
            ++ri;
        }
    }

    private void Reflection_coefficients(int[] l_acf, int[] r) {
        int i;
        int ri = 0;
        int[] ACF = new int[9];
        int[] P = new int[9];
        int[] K = new int[9];
        if (l_acf[0] == 0) {
            for (int i2 = 8; i2 > 0; --i2) {
                r[ri++] = 0;
            }
            return;
        }
        assert (l_acf[0] != 0);
        int temp = this.gsm_norm(l_acf[0]);
        assert (temp >= 0 && temp < 32);
        for (i = 0; i <= 8; ++i) {
            ACF[i] = this.sasr(l_acf[i] << temp, 16);
        }
        for (i = 1; i <= 7; ++i) {
            K[i] = ACF[i];
        }
        for (i = 0; i <= 8; ++i) {
            P[i] = ACF[i];
        }
        int n = 1;
        while (n <= 8) {
            temp = P[1];
            if (P[0] < (temp = this.abs(temp))) {
                for (i = n; i <= 8; ++i) {
                    r[ri++] = 0;
                }
                return;
            }
            r[ri] = this.gsm_div(temp, P[0]);
            assert (r[ri] >= 0);
            if (P[1] > 0) {
                r[ri] = -r[ri];
            }
            assert (r[ri] != Short.MIN_VALUE);
            if (n == 8) {
                return;
            }
            temp = GSMEncoder.mult_r(P[1], r[ri]);
            P[0] = GSMEncoder.add(P[0], temp);
            for (int m = 1; m <= 8 - n; ++m) {
                temp = GSMEncoder.mult_r(K[m], r[ri]);
                P[m] = GSMEncoder.add(P[m + 1], temp);
                temp = GSMEncoder.mult_r(P[m + 1], r[ri]);
                K[m] = GSMEncoder.add(K[m], temp);
            }
            ++n;
            ++ri;
        }
    }

    private int gsm_div(int num, int denum) {
        int L_num = num;
        int div = 0;
        int k = 15;
        assert (num >= 0 && denum >= num);
        if (num == 0) {
            return 0;
        }
        while (k-- > 0) {
            div <<= 1;
            if ((L_num <<= 1) < denum) continue;
            L_num -= denum;
            ++div;
        }
        return div;
    }

    int gsm_mult(int a, int b) {
        if (a == Short.MIN_VALUE && b == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        return a * b >> 15;
    }

    private void Autocorrelation(int[] s, int[] l_acf) {
        int j;
        int scalauto;
        int k;
        int si = this.dOffset;
        assert (this.dOffset == 0);
        int smax = 0;
        for (k = 0; k <= 159; ++k) {
            int temp = this.abs(s[si + k]);
            if (temp <= smax) continue;
            smax = temp;
        }
        if (smax == 0) {
            scalauto = 0;
        } else {
            assert (smax > 0);
            scalauto = 4 - this.gsm_norm(smax << 16);
        }
        if (scalauto > 0) {
            switch (scalauto) {
                case 1: {
                    for (k = 0; k <= 159; ++k) {
                        s[k] = GSMEncoder.mult_r(s[k], 16384);
                    }
                    break;
                }
                case 2: {
                    for (k = 0; k <= 159; ++k) {
                        s[k] = GSMEncoder.mult_r(s[k], 8192);
                    }
                    break;
                }
                case 3: {
                    for (k = 0; k <= 159; ++k) {
                        s[k] = GSMEncoder.mult_r(s[k], 4096);
                    }
                    break;
                }
                case 4: {
                    for (k = 0; k <= 159; ++k) {
                        s[k] = GSMEncoder.mult_r(s[k], 2048);
                    }
                    break;
                }
            }
        }
        int spi = 0;
        int sl = s[spi];
        for (k = 9; k > 0; --k) {
            l_acf[k - 1] = 0;
        }
        for (j = 0; j < 8; ++j) {
            for (int x = 0; x <= j; ++x) {
                int n = x;
                l_acf[n] = l_acf[n] + sl * s[spi - x];
            }
            if (j >= 7) continue;
            sl = s[++spi];
        }
        for (int i = 8; i <= 159; ++i) {
            sl = s[++spi];
            for (j = 0; j <= 8; ++j) {
                int n = j;
                l_acf[n] = l_acf[n] + sl * s[spi - j];
            }
        }
        for (k = 9; k > 0; --k) {
            int n = k - 1;
            l_acf[n] = l_acf[n] << 1;
        }
        if (scalauto > 0) {
            assert (scalauto <= 4);
            for (k = 160; k > 0; --k) {
                int n = si++;
                s[n] = s[n] << scalauto;
            }
        }
    }

    private int abs(int a) {
        return a < 0 ? (a == Short.MIN_VALUE ? Short.MAX_VALUE : -a) : a;
    }

    private int gsm_norm(int a) {
        assert (a != 0);
        if (a < 0) {
            if (a <= -1073741824) {
                return 0;
            }
            a ^= 0xFFFFFFFF;
        }
        return (a & 0xFFFF0000) != 0 ? ((a & 0xFF000000) != 0 ? -1 + bitoff[0xFF & a >> 24] : 7 + bitoff[0xFF & a >> 16]) : ((a & 0xFF00) != 0 ? 15 + bitoff[0xFF & a >> 8] : 23 + bitoff[0xFF & a]);
    }

    final void GsmPreprocess(int[] s, int[] so) {
        int k = 160;
        int si = 0;
        int soi = 0;
        while (k-- > 0) {
            int SO = this.sasr(s[si], 3) << 2;
            ++si;
            assert (SO >= -16384);
            assert (SO <= 16380);
            int s1 = SO - this.z1;
            this.z1 = SO;
            assert (s1 != Short.MIN_VALUE);
            int L_s2 = s1;
            L_s2 <<= 15;
            int msp = this.sasr(this.L_z2, 15);
            int lsp = this.L_z2 - (msp << 15);
            int L_temp = msp * 32735;
            this.L_z2 = (int)this.l_add(L_temp, L_s2 += GSMEncoder.mult_r(lsp, 32735));
            L_temp = (int)this.l_add(this.L_z2, 16384);
            msp = GSMEncoder.mult_r(this.mp, -28180);
            this.mp = this.sasr(L_temp, 15);
            so[soi++] = GSMEncoder.add(this.mp, msp);
        }
    }

    public static void print(String name, int[] data) {
        System.out.print("[" + name + ":");
        for (int i = 0; i < data.length; ++i) {
            System.out.print("" + data[i]);
            if (i < data.length - 1) {
                System.out.print(",");
                continue;
            }
            System.out.println("]");
        }
    }

    public static void print(String name, int data) {
        System.out.println("[" + name + ":" + data + "]");
    }

    private void APCMInverseQuantization(int[] xMc, int exp, int mant, int[] xMp) {
        int xmpi = 0;
        assert (mant >= 0 && mant <= 7);
        int xmci = this.xmcOffset;
        int temp1 = FAC[mant];
        int temp2 = GSMEncoder.sub(6, exp);
        int temp3 = GSMEncoder.asl(1, GSMEncoder.sub(temp2, 1));
        int i = 13;
        while (i-- > 0) {
            assert (xMc[xmci] <= 7 && xMc[xmci] >= 0);
            int temp = (xMc[xmci++] << 1) - 7;
            assert (temp <= 7 && temp >= -7);
            temp <<= 12;
            temp = GSMEncoder.mult_r(temp1, temp);
            temp = GSMEncoder.add(temp, temp3);
            xMp[xmpi++] = GSMEncoder.asr(temp, temp2);
        }
    }

    private static int saturate(int x) {
        return x < Short.MIN_VALUE ? Short.MIN_VALUE : (x > Short.MAX_VALUE ? Short.MAX_VALUE : x);
    }

    private static int sub(int a, int b) {
        int diff = a - b;
        return GSMEncoder.saturate(diff);
    }

    private static int add(int a, int b) {
        int sum = a + b;
        return GSMEncoder.saturate(sum);
    }

    private static int asl(int a, int n) {
        if (n >= 16) {
            return 0;
        }
        if (n <= -16) {
            return a < 0 ? -1 : 0;
        }
        if (n < 0) {
            return GSMEncoder.asr(a, -n);
        }
        return a << n;
    }

    private static int asr(int a, int n) {
        if (n >= 16) {
            return a < 0 ? -1 : 0;
        }
        if (n <= -16) {
            return 0;
        }
        if (n < 0) {
            return a << -n;
        }
        return a >> n;
    }

    private static int mult_r(int a, int b) {
        if (b == Short.MIN_VALUE && a == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        int prod = a * b + 16384;
        return GSMEncoder.saturate(prod >> 15);
    }

    private int sasr(int x, int by) {
        return x >= 0 ? x >> by : ~(-(x + 1) >> by);
    }

    /*
     * WARNING - void declaration
     */
    private long l_add(int a, int b) {
        void var3_4;
        long utmp;
        long l = a < 0 ? (b >= 0 ? (long)(a + b) : ((utmp = (long)(-(a + 1)) + (long)(-(b + 1))) >= Integer.MAX_VALUE ? Integer.MIN_VALUE : -utmp - 2L)) : (b <= 0 ? (long)(a + b) : ((utmp = (long)a + (long)b) >= Integer.MAX_VALUE ? Integer.MAX_VALUE : var3_4));
        return l;
    }

    private void Coefficients_0_12(int[] LARpp_j_1, int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = GSMEncoder.add(this.sasr(LARpp_j_1[i], 2), this.sasr(LARpp_j[i], 2));
            LARp[i] = GSMEncoder.add(LARp[i], this.sasr(LARpp_j_1[i], 1));
        }
    }

    private void Coefficients_13_26(int[] LARpp_j_1, int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = GSMEncoder.add(this.sasr(LARpp_j_1[i], 1), this.sasr(LARpp_j[i], 1));
        }
    }

    private void Coefficients_27_39(int[] LARpp_j_1, int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = GSMEncoder.add(this.sasr(LARpp_j_1[i], 2), this.sasr(LARpp_j[i], 2));
            LARp[i] = GSMEncoder.add(LARp[i], this.sasr(LARpp_j[i], 1));
        }
    }

    private static void Coefficients_40_159(int[] LARpp_j, int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            LARp[i] = LARpp_j[i];
        }
    }

    private static void LARp_to_rp(int[] LARp) {
        for (int i = 0; i < 8; ++i) {
            int temp;
            if (LARp[i] < 0) {
                int n = temp = LARp[i] == Short.MIN_VALUE ? Short.MAX_VALUE : -LARp[i];
                LARp[i] = -(temp < 11059 ? temp << 1 : (temp < 20070 ? temp + 11059 : GSMEncoder.add(temp >> 2, 26112)));
                continue;
            }
            temp = LARp[i];
            LARp[i] = temp < 11059 ? temp << 1 : (temp < 20070 ? temp + 11059 : GSMEncoder.add(temp >> 2, 26112));
        }
    }

    private void RPE_grid_positioning(int Mc, int[] xMp, int[] ep) {
        int i = 13;
        int epo = this.eOffset;
        int po = 0;
        switch (Mc) {
            case 3: {
                ep[epo++] = 0;
            }
            case 2: {
                ep[epo++] = 0;
            }
            case 1: {
                ep[epo++] = 0;
            }
            case 0: {
                ep[epo++] = xMp[po++];
                --i;
            }
        }
        do {
            ep[epo++] = 0;
            ep[epo++] = 0;
            ep[epo++] = xMp[po++];
        } while (--i > 0);
        while (++Mc < 4) {
            ep[epo++] = 0;
        }
    }

    public static void main(String[] args) {
        GSMEncoder encoder = new GSMEncoder();
        int[] s = new int[160];
        encoder.encode(s);
    }
}

