package GCPlugins::GCfilms::GCDVDSpot;

###################################################
#
#  Copyright 2007 Marc Deslauriers <marcdeslauriers@videotron.ca>
#  Copyright 2005-2009 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################
#
#  Plugin to import films details from dvdspot.com
#
#  Changelog:
#  Version 1.0 - Initial version - mdeslaur
#
###################################################
use strict;
use utf8;

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginDVDSpot;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ m|dvd.php\?d=([0-9]*)|)
                {
                    return if $self->{alreadyRetrieved}->{$1};
                    $self->{alreadyRetrieved}->{$1} = 1;
                    my $url = $attr->{href}; 
                    $self->{isMovie} = 1;
                    $self->{haveTitle} = 0;
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq 'div')
            { 
                $self->{isImage} = 1
                    if ($attr->{id} eq 'filmPhoto');
                $self->{isActors} = 1
                    if ($attr->{class} eq 'filmActor');
            }
            elsif ($tagname eq 'span')
            {
                $self->{isTitle} = 1
                    if ($attr->{class} eq 'dvdTitle');
            }
            elsif ($tagname eq 'a')
            {
                if ($attr->{href} =~ m|http://us.imdb.com/title/.*|)
                {		
                    $self->{curInfo}->{webPage} = $attr->{href};
                }
            }
            elsif ($tagname eq 'img')
            {
                if (($attr->{src} =~ m%^/covers/[0-9]*/[0-9]*.jpg%)
                 && (!$self->{curInfo}->{image}))
                {
                    $self->{curInfo}->{image} = "http://www.dvdspot.com".$attr->{src};
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{parsingEnded})
            {
                return;
            }
            if ($self->{isMovie})
            {
                if ($self->{inside}->{span} && !$self->{haveTitle})
                {
                    $origtext =~ s/^\s*//m;
                    $origtext =~ s/\s*$//m;
                    return if !$origtext;
                    $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                    $self->{haveTitle} = 1;
                    return;
                }
                if ($self->{inside}->{span} && $self->{haveTitle})
                {
                    return if !($origtext =~ /\s*\(([0-9]{4})\)\s*/);
                    $origtext =~ s/\s*\(([0-9]{4})\)\s*/$1/;
                    $self->{itemsList}[$self->{itemIdx}]->{date} = $origtext;
                    $self->{isMovie} = 0;
                }
            }
        }
        else
        {
            $origtext =~ s/\s{2,}//g;
                 
            return if !$origtext;       
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }

            if ($self->{insideDate})
            {
                if ($origtext =~ m/(.*)([0-9]{2}-[0-9]{2}-[0-9]{4})/)
                {
                    $self->{curInfo}->{date} = $origtext;
                }
                $self->{insideDate} = 0;
            }
            elsif ($self->{insideActors})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{actors} = $origtext;
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{director} = $origtext;
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideTime})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/\n//g;
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideAge})
            {
                $self->{curInfo}->{age} = 18 if $origtext eq 'R';
                $self->{curInfo}->{age} = 13 if $origtext =~ /PG\-13/;
                $self->{curInfo}->{age} = 5 if $origtext eq 'PG';
                $self->{curInfo}->{age} = 2 if $origtext eq 'G';
                $self->{insideAge} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{insideGenre})
            {
                $self->{curInfo}->{genre} = $origtext;
                $self->{insideGenre} = 0;
            }
            elsif ($self->{insideVideo})
            {
                if ($origtext =~ /Audio Tracks/)
                {
                $self->{insideVideo} = 0;
                $self->{insideAudio} = 1;
                return;
                }
	        $self->{curInfo}->{video} .= ',' if $self->{curInfo}->{video};
	        $self->{curInfo}->{video} .= $origtext;
            }
            elsif ($self->{insideAudio})
            {

                if ($origtext =~ /Disc Count/)
                {
                $self->{insideAudio} = 0;
                return;
                }
	        $self->{curInfo}->{audio} .= ',' if $self->{curInfo}->{audio};
	        $self->{curInfo}->{audio} .= $origtext;
            }
            elsif ($self->{inside}->{span})
            {
    		$self->{insideDate} = 1 if $origtext =~ /Released/;
                $self->{insideActors} = 1 if $origtext =~ /Cast/;
		$self->{insideDirector} = 1 if $origtext =~ /Director\(s\)/;
		$self->{insideTime} = 1 if $origtext =~ /Runtime/;
		$self->{insideSynopsis} = 1 if $origtext =~ /Synopsis/;
		$self->{insideGenre} = 1 if $origtext =~ /Genre/;
		$self->{insideAge} = 1 if $origtext =~ /MPAA Rating/;
		$self->{insideVideo} = 1 if $origtext =~ /Video Tracks/;
		$self->{insideAudio} = 1 if $origtext =~ /Audio Tracks/;
            }        
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 1,
            director => 0,
            actors => 0
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $self->{parsingEnded} = 0;
        $self->{insideResults} = 0;
        $self->{actorsCounter} = 0;
        $self->{alreadyRetrieved} = {};
        $self->{haveTitle} = 0;

        if (!$self->{parsingList})
        {
             $html =~ s|<a href="list.php[^"]*">(.*?)</a>|$1|gms;
        }

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.dvdspot.com/search.php?search=titleupc&query=$word&display=100"
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
		return "http://www.dvdspot.com/".$url;        
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "DVDSpot";
    }
    
    sub getAuthor
    {
        return 'mdeslaur';
    }
    
    sub getLang
    {
        return 'EN';
    }
}

1;
