/*
 * chttpd/1.0 
 * *   exported socket functions
 * *   Copyright (c) 0x7d0 Greg Olszewski <noop@nwonknu.org>
 * *   dhttpd/1.02 - Personal web page server
 * *   Copyright (C) 1997  David A. Bartold
 * *
 * *   This program is free software; you can redistribute it and/or modify
 * *   it under the terms of the GNU General Public License as published by
 * *   the Free Software Foundation; either version 2 of the License, or
 * *   (at your option) any later version.
 * *
 * *   This program is distributed in the hope that it will be useful,
 * *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *   GNU General Public License for more details.
 * *
 * *   You should have received a copy of the GNU General Public License
 * *   along with this program; if not, write to the Free Software
 * *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
struct listen_sock {
    int             socket;
    struct sockaddr_in sin;
};

struct active_sock {
    int             socket;
    FILE           *io;
    struct in_addr  peer_addr;
};

/*
 * sets up a listening socket 
 */
int             get_listen_sock(const int port,
				struct listen_sock *socket);

/*
 * gets a new connection 
 */
int             accept_sock(struct listen_sock socket);

/*
 * shuts it down 
 */
void            shutdown_sock(struct listen_sock socket);

/*
 * sets up a request(active) socket 
 */
int             get_active_sock(struct active_sock *socket,
				const int socketd);

/*
 * deals with a conncection 
 */
void            handle_socket(struct active_sock a_sock);
