/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.agent;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.subsonic.booter.agent.SubsonicAgent;
import net.sourceforge.subsonic.booter.agent.SubsonicListener;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsPanel
extends JPanel
implements SubsonicListener {
    private JTextField portTextField;
    private JCheckBox httpsPortCheckBox;
    private JTextField httpsPortTextField;
    private JComboBox contextPathComboBox;
    private JTextField memoryTextField;
    private JButton defaultButton;
    private JButton saveButton;

    public SettingsPanel(SubsonicAgent subsonicAgent) {
        this.createComponents();
        this.configureComponents();
        this.layoutComponents();
        this.addBehaviour();
        this.setValues();
        subsonicAgent.addListener(this);
    }

    public void setValues() {
        this.portTextField.setText(String.valueOf(this.getPortFromOptionsFile()));
        this.memoryTextField.setText(String.valueOf(this.getMemoryLimitFromOptionsFile()));
        this.contextPathComboBox.setSelectedItem(this.getContextPathFromOptionsFile());
        int httpsPort = this.getHttpsPortFromOptionsFile();
        boolean httpsEnabled = httpsPort != 0;
        this.httpsPortTextField.setText(String.valueOf(httpsEnabled ? httpsPort : 443));
        this.httpsPortTextField.setEnabled(httpsEnabled);
        this.httpsPortCheckBox.setSelected(httpsEnabled);
    }

    private int getHttpsPortFromOptionsFile() {
        try {
            String s = this.grep("-Dsubsonic.httpsPort=(\\d+)");
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            x.printStackTrace();
            return 0;
        }
    }

    private int getPortFromOptionsFile() {
        try {
            String s = this.grep("-Dsubsonic.port=(\\d+)");
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            x.printStackTrace();
            return 80;
        }
    }

    private int getMemoryLimitFromOptionsFile() {
        try {
            String s = this.grep("-Xmx(\\d+)m");
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            x.printStackTrace();
            return 100;
        }
    }

    private String getContextPathFromOptionsFile() {
        try {
            String s = this.grep("-Dsubsonic.contextPath=(.*)");
            if (s == null) {
                throw new NullPointerException();
            }
            return s;
        }
        catch (Exception x) {
            x.printStackTrace();
            return "/";
        }
    }

    private void createComponents() {
        this.portTextField = new JTextField();
        this.httpsPortTextField = new JTextField();
        this.httpsPortCheckBox = new JCheckBox("Enable https on port");
        this.contextPathComboBox = new JComboBox();
        this.memoryTextField = new JTextField();
        this.defaultButton = new JButton("Restore defaults");
        this.saveButton = new JButton("Save settings");
    }

    private void configureComponents() {
        this.contextPathComboBox.setEditable(true);
        this.contextPathComboBox.addItem("/");
        this.contextPathComboBox.addItem("/subsonic");
        this.contextPathComboBox.addItem("/music");
    }

    private void layoutComponents() {
        FormLayout layout = new FormLayout("d, 6dlu, max(d;30dlu):grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append("Port number", (Component)this.portTextField);
        builder.append((Component)this.httpsPortCheckBox, (Component)this.httpsPortTextField);
        builder.append("Memory limit (MB)", (Component)this.memoryTextField);
        builder.append("Context path", (Component)this.contextPathComboBox);
        this.setBorder(Borders.DIALOG_BORDER);
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)builder.getPanel(), "Center");
        this.add((Component)ButtonBarFactory.buildCenteredBar(this.defaultButton, this.saveButton), "South");
    }

    private void addBehaviour() {
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SettingsPanel.this.saveSettings(SettingsPanel.this.getMemoryLimit(), SettingsPanel.this.getPort(), SettingsPanel.this.getHttpsPort(), SettingsPanel.this.getContextPath());
                    JOptionPane.showMessageDialog(SettingsPanel.this, "Please restart Subsonic for the new settings to take effect.", "Settings changed", 1);
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(SettingsPanel.this, x.getMessage(), "Error", 2);
                }
            }
        });
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.portTextField.setText(String.valueOf(80));
                SettingsPanel.this.httpsPortTextField.setText("443");
                SettingsPanel.this.httpsPortTextField.setEnabled(false);
                SettingsPanel.this.httpsPortCheckBox.setSelected(false);
                SettingsPanel.this.memoryTextField.setText(String.valueOf(100));
                SettingsPanel.this.contextPathComboBox.setSelectedItem("/");
            }
        });
        this.httpsPortCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.httpsPortTextField.setEnabled(SettingsPanel.this.httpsPortCheckBox.isSelected());
            }
        });
    }

    private String getContextPath() throws SettingsException {
        String contextPath = (String)this.contextPathComboBox.getSelectedItem();
        if (contextPath.contains(" ") || !contextPath.startsWith("/")) {
            throw new SettingsException("Please specify a valid context path.");
        }
        return contextPath;
    }

    private int getMemoryLimit() throws SettingsException {
        int memoryLimit;
        try {
            memoryLimit = Integer.parseInt(this.memoryTextField.getText().trim());
            if (memoryLimit < 5) {
                throw new Exception();
            }
        }
        catch (Exception x) {
            throw new SettingsException("Please specify a valid memory limit.", x);
        }
        return memoryLimit;
    }

    private int getPort() throws SettingsException {
        int port;
        try {
            port = Integer.parseInt(this.portTextField.getText().trim());
            if (port < 1 || port > 65535) {
                throw new Exception();
            }
        }
        catch (Exception x) {
            throw new SettingsException("Please specify a valid port number.", x);
        }
        return port;
    }

    private int getHttpsPort() throws SettingsException {
        int port;
        if (!this.httpsPortCheckBox.isSelected()) {
            return 0;
        }
        try {
            port = Integer.parseInt(this.httpsPortTextField.getText().trim());
            if (port < 1 || port > 65535) {
                throw new Exception();
            }
        }
        catch (Exception x) {
            throw new SettingsException("Please specify a valid https port number.", x);
        }
        return port;
    }

    private void saveSettings(int memoryLimit, int port, int httpsPort, String contextPath) throws SettingsException {
        File file = this.getOptionsFile();
        List<String> lines = this.readLines(file);
        ArrayList<String> newLines = new ArrayList<String>();
        boolean memoryLimitAdded = false;
        boolean portAdded = false;
        boolean httpsPortAdded = false;
        boolean contextPathAdded = false;
        for (String line : lines) {
            if (line.startsWith("-Xmx")) {
                newLines.add("-Xmx" + memoryLimit + "m");
                memoryLimitAdded = true;
                continue;
            }
            if (line.startsWith("-Dsubsonic.port=")) {
                newLines.add("-Dsubsonic.port=" + port);
                portAdded = true;
                continue;
            }
            if (line.startsWith("-Dsubsonic.httpsPort=")) {
                newLines.add("-Dsubsonic.httpsPort=" + httpsPort);
                httpsPortAdded = true;
                continue;
            }
            if (line.startsWith("-Dsubsonic.contextPath=")) {
                newLines.add("-Dsubsonic.contextPath=" + contextPath);
                contextPathAdded = true;
                continue;
            }
            newLines.add(line);
        }
        if (!memoryLimitAdded) {
            newLines.add("-Xmx" + memoryLimit + "m");
        }
        if (!portAdded) {
            newLines.add("-Dsubsonic.port=" + port);
        }
        if (!httpsPortAdded) {
            newLines.add("-Dsubsonic.httpsPort=" + httpsPort);
        }
        if (!contextPathAdded) {
            newLines.add("-Dsubsonic.contextPath=" + contextPath);
        }
        this.writeLines(file, newLines);
    }

    private File getOptionsFile() throws SettingsException {
        File file = new File("subsonic-service.exe.vmoptions");
        if (!file.isFile() || !file.exists()) {
            throw new SettingsException("File " + file.getAbsolutePath() + " not found.");
        }
        return file;
    }

    private List<String> readLines(File file) throws SettingsException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            Object line = reader.readLine();
            while (line != null) {
                lines.add((String)line);
                line = reader.readLine();
            }
            line = lines;
            this.closeQuietly(reader);
            return line;
        }
        catch (IOException x) {
            try {
                throw new SettingsException("Failed to read from file " + file.getAbsolutePath(), x);
            }
            catch (Throwable throwable) {
                this.closeQuietly(reader);
                throw throwable;
            }
        }
    }

    private void writeLines(File file, List<String> lines) throws SettingsException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            for (String line : lines) {
                writer.println(line);
            }
            this.closeQuietly(writer);
        }
        catch (IOException x) {
            try {
                throw new SettingsException("Failed to write to file " + file.getAbsolutePath(), x);
            }
            catch (Throwable throwable) {
                this.closeQuietly(writer);
                throw throwable;
            }
        }
    }

    private String grep(String regexp) throws SettingsException {
        Pattern pattern = Pattern.compile(regexp);
        File file = this.getOptionsFile();
        for (String line : this.readLines(file)) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private void closeQuietly(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeQuietly(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDeploymentStatus(DeploymentStatus deploymentStatus) {
    }

    @Override
    public void notifyServiceStatus(String serviceStatus) {
    }

    private static class SettingsException
    extends Exception {
        public SettingsException(String message, Throwable cause) {
            super(message, cause);
        }

        public SettingsException(String message) {
            this(message, null);
        }

        public String getMessage() {
            if (this.getCause() == null || this.getCause().getMessage() == null) {
                return super.getMessage();
            }
            return super.getMessage() + " " + this.getCause().getMessage();
        }
    }
}

