/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.agent;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.UIManager;
import net.sourceforge.subsonic.booter.agent.SubsonicFrame;
import net.sourceforge.subsonic.booter.agent.SubsonicListener;
import net.sourceforge.subsonic.booter.agent.TrayController;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;
import net.sourceforge.subsonic.booter.deployer.SubsonicDeployerService;
import org.apache.commons.io.IOUtils;

public class SubsonicAgent {
    private final List<SubsonicListener> listeners = new ArrayList<SubsonicListener>();
    private final TrayController trayController;
    private final SubsonicFrame frame;
    private final SubsonicDeployerService service;
    private static final int POLL_INTERVAL_DEPLOYMENT_INFO_SECONDS = 5;
    private static final int POLL_INTERVAL_SERVICE_STATUS_SECONDS = 5;
    private String url;
    private boolean serviceStatusPollingEnabled;

    public SubsonicAgent(SubsonicDeployerService service) {
        this.setLookAndFeel();
        this.service = service;
        this.trayController = new TrayController(this);
        this.frame = new SubsonicFrame(this);
        this.startPolling();
    }

    private void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
        }
        catch (Throwable x) {
            System.err.println("Failed to set look-and-feel.\n" + x);
        }
    }

    private void startPolling() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    SubsonicAgent.this.notifyDeploymentInfo(SubsonicAgent.this.service.getDeploymentInfo());
                }
                catch (Throwable x) {
                    SubsonicAgent.this.notifyDeploymentInfo(null);
                }
            }
        };
        executor.scheduleWithFixedDelay(runnable, 0L, 5L, TimeUnit.SECONDS);
        runnable = new Runnable(){

            public void run() {
                if (SubsonicAgent.this.serviceStatusPollingEnabled) {
                    try {
                        SubsonicAgent.this.notifyServiceStatus(SubsonicAgent.this.getServiceStatus());
                    }
                    catch (Throwable x) {
                        SubsonicAgent.this.notifyServiceStatus(null);
                    }
                }
            }
        };
        executor.scheduleWithFixedDelay(runnable, 0L, 5L, TimeUnit.SECONDS);
    }

    private String getServiceStatus() throws Exception {
        Process process = Runtime.getRuntime().exec("subsonic-service.exe -status");
        return IOUtils.toString(process.getInputStream());
    }

    public void setServiceStatusPollingEnabled(boolean enabled) {
        this.serviceStatusPollingEnabled = enabled;
    }

    public void startOrStopService(boolean start) {
        try {
            Runtime.getRuntime().exec("subsonic-service.exe " + (start ? "-start" : "-stop"));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void addListener(SubsonicListener listener) {
        this.listeners.add(listener);
    }

    private void notifyDeploymentInfo(DeploymentStatus status) {
        if (status != null) {
            this.url = status.getURL();
        }
        for (SubsonicListener listener : this.listeners) {
            listener.notifyDeploymentStatus(status);
        }
    }

    private void notifyServiceStatus(String status) {
        for (SubsonicListener listener : this.listeners) {
            listener.notifyServiceStatus(status);
        }
    }

    public void showControlPanel() {
        this.frame.showControlPanel();
    }

    public void exit() {
        this.trayController.uninstallComponents();
        System.exit(0);
    }

    public void openBrowser() {
        try {
            Desktop.getDesktop().browse(new URI(this.url));
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }
}

