/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.agent;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.subsonic.booter.Main;
import net.sourceforge.subsonic.booter.agent.SettingsPanel;
import net.sourceforge.subsonic.booter.agent.StatusPanel;
import net.sourceforge.subsonic.booter.agent.SubsonicAgent;

public class SubsonicFrame
extends JFrame {
    private final SubsonicAgent subsonicAgent;
    private JTabbedPane tabbedPane;
    private StatusPanel statusPanel;
    private SettingsPanel settingsPanel;
    private JButton closeButton;

    public SubsonicFrame(SubsonicAgent subsonicAgent) {
        super("Subsonic Control Panel");
        this.subsonicAgent = subsonicAgent;
        this.createComponents();
        this.layoutComponents();
        this.addBehaviour();
        this.setupIcons();
        this.pack();
        this.centerComponent();
    }

    private void setupIcons() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Method method = Window.class.getMethod("setIconImages", List.class);
            List<Image> images = Arrays.asList(toolkit.createImage(Main.class.getResource("/images/subsonic-16.png")), toolkit.createImage(Main.class.getResource("/images/subsonic-32.png")), toolkit.createImage(Main.class.getResource("/images/subsonic-512.png")));
            method.invoke((Object)this, images);
        }
        catch (Throwable x) {
            this.setIconImage(toolkit.createImage(Main.class.getResource("/images/subsonic-32.png")));
        }
    }

    public void centerComponent() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
    }

    private void createComponents() {
        this.statusPanel = new StatusPanel(this.subsonicAgent);
        this.settingsPanel = new SettingsPanel(this.subsonicAgent);
        this.tabbedPane = new JTabbedPane();
        this.closeButton = new JButton("Close");
    }

    private void layoutComponents() {
        this.tabbedPane.add("Status", this.statusPanel);
        this.tabbedPane.add("Settings", this.settingsPanel);
        JPanel pane = (JPanel)this.getContentPane();
        pane.setLayout(new BorderLayout(10, 10));
        pane.add((Component)this.tabbedPane, "Center");
        pane.add((Component)ButtonBarFactory.buildCloseBar(this.closeButton), "South");
        pane.setBorder(Borders.TABBED_DIALOG_BORDER);
    }

    private void addBehaviour() {
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubsonicFrame.this.setVisible(false);
            }
        });
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.subsonicAgent.setServiceStatusPollingEnabled(b);
    }

    public void showControlPanel() {
        this.settingsPanel.setValues();
        this.tabbedPane.setSelectedComponent(this.statusPanel);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }
}

