/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.BindException;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;
import net.sourceforge.subsonic.booter.deployer.SubsonicDeployerService;
import org.apache.commons.io.IOUtils;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class SubsonicDeployer
implements SubsonicDeployerService {
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 0;
    public static final int DEFAULT_MEMORY_LIMIT = 100;
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final String DEFAULT_WAR = "subsonic.war";
    private static final int MAX_IDLE_TIME_MILLIS = 604800000;
    private static final int HEADER_BUFFER_SIZE = 65536;
    private static final File SUBSONIC_HOME_WINDOWS = new File("c:/subsonic");
    private static final File SUBSONIC_HOME_OTHER = new File("/var/subsonic");
    private Throwable exception;
    private File subsonicHome;
    private final Date startTime;

    public SubsonicDeployer() {
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        this.startTime = new Date();
        this.createLinkFile();
        this.deployWebApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkFile() {
        if ("true".equals(System.getProperty("subsonic.createLinkFile"))) {
            FileWriter writer = null;
            try {
                writer = new FileWriter("subsonic.url");
                ((Writer)writer).append("[InternetShortcut]");
                ((Writer)writer).append(System.getProperty("line.separator"));
                ((Writer)writer).append("URL=").append(this.getUrl());
                ((Writer)writer).flush();
            }
            catch (Throwable x) {
                System.err.println("Failed to create subsonic.url.");
                x.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException x) {}
                }
            }
        }
    }

    private void deployWebApp() {
        try {
            Server server = new Server();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setMaxIdleTime(604800000);
            connector.setHeaderBufferSize(65536);
            connector.setHost(this.getHost());
            connector.setPort(this.getPort());
            if (this.isHttpsEnabled()) {
                connector.setConfidentialPort(this.getHttpsPort());
            }
            server.addConnector(connector);
            if (this.isHttpsEnabled()) {
                SslSocketConnector sslConnector = new SslSocketConnector();
                sslConnector.setMaxIdleTime(604800000);
                sslConnector.setHeaderBufferSize(65536);
                sslConnector.setHost(this.getHost());
                sslConnector.setPort(this.getHttpsPort());
                sslConnector.setKeystore(System.getProperty("subsonic.ssl.keystore", this.getClass().getResource("/subsonic.keystore").toExternalForm()));
                sslConnector.setPassword(System.getProperty("subsonic.ssl.password", "subsonic"));
                server.addConnector(sslConnector);
            }
            WebAppContext context = new WebAppContext();
            context.setTempDirectory(this.getJettyDirectory());
            context.setContextPath(this.getContextPath());
            context.setWar(this.getWar());
            if (this.isHttpsEnabled()) {
                ConstraintMapping constraintMapping = new ConstraintMapping();
                Constraint constraint = new Constraint();
                constraint.setDataConstraint(2);
                constraintMapping.setPathSpec(DEFAULT_CONTEXT_PATH);
                constraintMapping.setConstraint(constraint);
                context.getSecurityHandler().setConstraintMappings(new ConstraintMapping[]{constraintMapping});
            }
            server.addHandler(context);
            server.start();
            System.err.println("Subsonic running on: " + this.getUrl());
            if (this.isHttpsEnabled()) {
                System.err.println("                and: " + this.getHttpsUrl());
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            this.exception = x;
        }
    }

    private File getJettyDirectory() {
        File dir = new File(this.getSubsonicHome(), "jetty");
        String buildNumber = this.getSubsonicBuildNumber();
        if (buildNumber != null) {
            dir = new File(dir, buildNumber);
        }
        System.err.println("Extracting webapp to " + dir);
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("Failed to create directory " + dir);
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubsonicBuildNumber() {
        Object jar;
        File war = new File(this.getWar());
        InputStream in = null;
        try {
            if (war.isFile()) {
                jar = new JarFile(war);
                ZipEntry entry = ((JarFile)jar).getEntry("WEB-INF\\classes\\build_number.txt");
                if (entry == null) {
                    entry = ((JarFile)jar).getEntry("WEB-INF/classes/build_number.txt");
                }
                in = ((JarFile)jar).getInputStream(entry);
            } else {
                in = new FileInputStream(war.getPath() + "/WEB-INF/classes/build_number.txt");
            }
            jar = IOUtils.toString(in);
        }
        catch (Exception x) {
            String string;
            try {
                System.err.println("Failed to resolve build number from WAR: " + war);
                x.printStackTrace();
                string = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            return string;
        }
        IOUtils.closeQuietly(in);
        return jar;
    }

    private String getContextPath() {
        return System.getProperty("subsonic.contextPath", DEFAULT_CONTEXT_PATH);
    }

    private String getWar() {
        File file;
        String war = System.getProperty(DEFAULT_WAR);
        if (war == null) {
            war = DEFAULT_WAR;
        }
        if ((file = new File(war)).exists()) {
            System.err.println("Using WAR file: " + file.getAbsolutePath());
        } else {
            System.err.println("Error: WAR file not found: " + file.getAbsolutePath());
        }
        return war;
    }

    private String getHost() {
        return System.getProperty("subsonic.host", DEFAULT_HOST);
    }

    private int getPort() {
        int port = 80;
        String portString = System.getProperty("subsonic.port");
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        System.setProperty("subsonic.port", String.valueOf(port));
        return port;
    }

    private int getHttpsPort() {
        int port = 0;
        String portString = System.getProperty("subsonic.httpsPort");
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        System.setProperty("subsonic.httpsPort", String.valueOf(port));
        return port;
    }

    private boolean isHttpsEnabled() {
        return this.getHttpsPort() > 0;
    }

    public String getErrorMessage() {
        if (this.exception == null) {
            return null;
        }
        if (this.exception instanceof BindException) {
            return "Address already in use. Please change port number.";
        }
        return this.exception.toString();
    }

    public int getMemoryUsed() {
        long freeBytes = Runtime.getRuntime().freeMemory();
        long totalBytes = Runtime.getRuntime().totalMemory();
        long usedBytes = totalBytes - freeBytes;
        return (int)Math.round((double)usedBytes / 1024.0 / 1024.0);
    }

    private String getUrl() {
        String host = DEFAULT_HOST.equals(this.getHost()) ? "localhost" : this.getHost();
        StringBuffer url = new StringBuffer("http://").append(host);
        if (this.getPort() != 80) {
            url.append(":").append(this.getPort());
        }
        url.append(this.getContextPath());
        return url.toString();
    }

    private String getHttpsUrl() {
        if (!this.isHttpsEnabled()) {
            return null;
        }
        String host = DEFAULT_HOST.equals(this.getHost()) ? "localhost" : this.getHost();
        StringBuffer url = new StringBuffer("https://").append(host);
        if (this.getHttpsPort() != 443) {
            url.append(":").append(this.getHttpsPort());
        }
        url.append(this.getContextPath());
        return url.toString();
    }

    private File getSubsonicHome() {
        File home;
        if (this.subsonicHome != null) {
            return this.subsonicHome;
        }
        String overrideHome = System.getProperty("subsonic.home");
        if (overrideHome != null) {
            home = new File(overrideHome);
        } else {
            boolean isWindows = System.getProperty("os.name", "Windows").toLowerCase().startsWith("windows");
            File file = home = isWindows ? SUBSONIC_HOME_WINDOWS : SUBSONIC_HOME_OTHER;
        }
        if (!home.exists() || !home.isDirectory()) {
            boolean success = home.mkdirs();
            if (success) {
                this.subsonicHome = home;
            } else {
                String message = "The directory " + home + " does not exist. Please create it and make it writable. " + "(You can override the directory location by specifying -Dsubsonic.home=... when " + "starting the servlet container.)";
                System.err.println("ERROR: " + message);
            }
        } else {
            this.subsonicHome = home;
        }
        return home;
    }

    public DeploymentStatus getDeploymentInfo() {
        return new DeploymentStatus(this.startTime, this.getUrl(), this.getHttpsUrl(), this.getMemoryUsed(), this.getErrorMessage());
    }
}

