/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.mac;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.text.DateFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;
import net.sourceforge.subsonic.booter.deployer.SubsonicDeployerService;

public class StatusPanel
extends JPanel {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final SubsonicDeployerService deployer;
    private JTextField startedTextField;
    private JTextField memoryTextField;
    private JTextArea errorTextField;
    private JButton urlButton;

    public StatusPanel(SubsonicDeployerService deployer) {
        this.deployer = deployer;
        this.createComponents();
        this.configureComponents();
        this.layoutComponents();
        this.addBehaviour();
    }

    private void createComponents() {
        this.startedTextField = new JTextField();
        this.memoryTextField = new JTextField();
        this.errorTextField = new JTextArea(3, 24);
        this.urlButton = new JButton();
    }

    private void configureComponents() {
        this.startedTextField.setEditable(false);
        this.memoryTextField.setEditable(false);
        this.errorTextField.setEditable(false);
        this.errorTextField.setLineWrap(true);
        this.errorTextField.setBorder(this.startedTextField.getBorder());
        this.urlButton.setBorderPainted(false);
        this.urlButton.setContentAreaFilled(false);
        this.urlButton.setForeground(Color.BLUE.darker());
        this.urlButton.setHorizontalAlignment(2);
    }

    private void layoutComponents() {
        FormLayout layout = new FormLayout("right:d, 6dlu, max(d;30dlu):grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, this);
        builder.append("Started on", (Component)this.startedTextField);
        builder.append("Memory used", (Component)this.memoryTextField);
        builder.append("Error message", (Component)this.errorTextField);
        builder.append("Server address", (Component)this.urlButton);
        this.setBorder(Borders.DIALOG_BORDER);
    }

    private void addBehaviour() {
        this.urlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.openBrowser();
            }
        });
        Timer timer = new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.updateStatus(StatusPanel.this.deployer.getDeploymentInfo());
            }
        });
        this.updateStatus(this.deployer.getDeploymentInfo());
        timer.start();
    }

    private void openBrowser() {
        String url = this.urlButton.getText();
        if (url == null) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    private void updateStatus(DeploymentStatus status) {
        this.startedTextField.setText(status == null ? null : DATE_FORMAT.format(status.getStartTime()));
        this.memoryTextField.setText(status == null ? null : status.getMemoryUsed() + " MB");
        this.errorTextField.setText(status == null ? null : status.getErrorMessage());
        this.urlButton.setText(status == null ? null : status.getURL());
    }
}

