/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.JdoObjectRetrievalFailureException;
import org.springframework.orm.jdo.JdoOptimisticLockingFailureException;
import org.springframework.orm.jdo.JdoResourceFailureException;
import org.springframework.orm.jdo.JdoSystemException;
import org.springframework.orm.jdo.JdoUsageException;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class PersistenceManagerFactoryUtils {
    public static final int PERSISTENCE_MANAGER_SYNCHRONIZATION_ORDER = 900;
    private static final Log logger = LogFactory.getLog(PersistenceManagerFactoryUtils.class);

    static SQLExceptionTranslator newJdbcExceptionTranslator(Object connectionFactory) {
        if (connectionFactory instanceof DataSource) {
            return new SQLErrorCodeSQLExceptionTranslator((DataSource)connectionFactory);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static PersistenceManager getPersistenceManager(PersistenceManagerFactory pmf, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return PersistenceManagerFactoryUtils.doGetPersistenceManager(pmf, allowCreate);
        }
        catch (JDOException ex) {
            throw new DataAccessResourceFailureException("Could not obtain JDO PersistenceManager", ex);
        }
    }

    public static PersistenceManager doGetPersistenceManager(PersistenceManagerFactory pmf, boolean allowCreate) throws JDOException, IllegalStateException {
        Assert.notNull(pmf, "No PersistenceManagerFactory specified");
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.getResource(pmf);
        if (pmHolder != null) {
            if (!pmHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                pmHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.registerSynchronization(new PersistenceManagerSynchronization(pmHolder, pmf, false));
            }
            return pmHolder.getPersistenceManager();
        }
        if (!allowCreate && !TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("No JDO PersistenceManager bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        logger.debug("Opening JDO PersistenceManager");
        PersistenceManager pm = pmf.getPersistenceManager();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug("Registering transaction synchronization for JDO PersistenceManager");
            pmHolder = new PersistenceManagerHolder(pm);
            pmHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization(new PersistenceManagerSynchronization(pmHolder, pmf, true));
            TransactionSynchronizationManager.bindResource(pmf, pmHolder);
        }
        return pm;
    }

    public static boolean isPersistenceManagerTransactional(PersistenceManager pm, PersistenceManagerFactory pmf) {
        if (pmf == null) {
            return false;
        }
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.getResource(pmf);
        return pmHolder != null && pm == pmHolder.getPersistenceManager();
    }

    public static void applyTransactionTimeout(Query query, PersistenceManagerFactory pmf, JdoDialect jdoDialect) throws JDOException {
        Assert.notNull(query, "No Query object specified");
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.getResource(pmf);
        if (pmHolder != null && pmHolder.hasTimeout()) {
            jdoDialect.applyQueryTimeout(query, pmHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertJdoAccessException(JDOException ex) {
        if (ex instanceof JDOObjectNotFoundException) {
            throw new JdoObjectRetrievalFailureException((JDOObjectNotFoundException)ex);
        }
        if (ex instanceof JDOOptimisticVerificationException) {
            throw new JdoOptimisticLockingFailureException((JDOOptimisticVerificationException)ex);
        }
        if (ex instanceof JDODataStoreException) {
            return new JdoResourceFailureException((JDODataStoreException)ex);
        }
        if (ex instanceof JDOFatalDataStoreException) {
            return new JdoResourceFailureException((JDOFatalDataStoreException)ex);
        }
        if (ex instanceof JDOUserException) {
            return new JdoUsageException((JDOUserException)ex);
        }
        if (ex instanceof JDOFatalUserException) {
            return new JdoUsageException((JDOFatalUserException)ex);
        }
        return new JdoSystemException(ex);
    }

    public static void releasePersistenceManager(PersistenceManager pm, PersistenceManagerFactory pmf) {
        try {
            PersistenceManagerFactoryUtils.doReleasePersistenceManager(pm, pmf);
        }
        catch (JDOException ex) {
            logger.debug("Could not close JDO PersistenceManager", ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing JDO PersistenceManager", ex);
        }
    }

    public static void doReleasePersistenceManager(PersistenceManager pm, PersistenceManagerFactory pmf) throws JDOException {
        if (pm == null) {
            return;
        }
        if (!PersistenceManagerFactoryUtils.isPersistenceManagerTransactional(pm, pmf)) {
            logger.debug("Closing JDO PersistenceManager");
            pm.close();
        }
    }

    private static class PersistenceManagerSynchronization
    extends ResourceHolderSynchronization
    implements Ordered {
        private final boolean newPersistenceManager;

        public PersistenceManagerSynchronization(PersistenceManagerHolder pmHolder, PersistenceManagerFactory pmf, boolean newPersistenceManager) {
            super(pmHolder, pmf);
            this.newPersistenceManager = newPersistenceManager;
        }

        public int getOrder() {
            return 900;
        }

        protected boolean shouldUnbindAtCompletion() {
            return this.newPersistenceManager;
        }

        protected void releaseResource(ResourceHolder resourceHolder, Object resourceKey) {
            PersistenceManagerFactoryUtils.releasePersistenceManager(((PersistenceManagerHolder)resourceHolder).getPersistenceManager(), (PersistenceManagerFactory)resourceKey);
        }
    }
}

