import wx, wx.html
import wx.calendar
from etm.etmParsers import *

# class ETMcal(wx.Dialog):
class ETMcal(wx.Frame):
    def __init__(self, parent):
        wx.Frame.__init__(self, parent, -1, 'etm', size=(225,225))
        self.parent = parent
        self.parent.selecteddate = None
        sd = wx.DateTime_Now()
        cal = wx.calendar.CalendarCtrl(self, -1, date=sd,
                size = (-1, -1),
                style = wx.calendar.CAL_SHOW_HOLIDAYS
                    | wx.calendar.CAL_SUNDAY_FIRST
                    | wx.calendar.CAL_SHOW_SURROUNDING_WEEKS
                    )
        self.cal = cal
        self.Bind(wx.calendar.EVT_CALENDAR_SEL_CHANGED, 
                self.OnCalSelChanged, id=cal.GetId())
        self.Bind(wx.calendar.EVT_CALENDAR, self.OnCalSelected, 
                id=cal.GetId())

        ok = wx.Button(self, wx.ID_OK, "OK")
        ok.SetDefault()
        self.Bind(wx.EVT_BUTTON, self.OnQuit, id=ok.GetId())

        # cancel = wx.Button(self, wx.ID_CANCEL, "CANCEL")
        # self.Bind(wx.EVT_BUTTON, self.OnCancel, id=cancel.GetId())
 
        vbox = wx.BoxSizer(wx.VERTICAL)
        vbox.Add(cal, 0, wx.EXPAND | wx.ALL, 5)
        hbox = wx.BoxSizer(wx.HORIZONTAL)
        # hbox.Add(cancel, 1, wx.ALIGN_RIGHT | wx.ALL, 5)
        hbox.Add(ok, 1, wx.ALIGN_RIGHT | wx.ALL, 5)
        vbox.Add(hbox, 0, wx.ALIGN_CENTER)
        self.SetSizerAndFit(vbox)
        self.Layout()

    def OnCalSelChanged(self, event):
        self.parent.selecteddate = event.GetDate().Format("%Y-%m-%d")

    def OnCalSelected(self, event):
        self.parent.selecteddate = event.GetDate().Format("%Y-%m-%d")
        self.Destroy()
        
    def OnCancel(self, event):
        self.parent.selecteddate = None
        self.Destroy()

    def OnQuit(self, event):
        self.Destroy() 


class ETM12cal(wx.Frame):
    def __init__(self, size=wx.DefaultSize):
        wx.Frame.__init__(self, None, -1, 'etm', size=(560, 680))
        self.html = wx.html.HtmlWindow(self)
        if "gtk2" in wx.PlatformInfo:
            self.html.SetStandardFonts(htmlfont+4, '', '')
        else:
            self.html.SetFonts('', '', [i for i in range(htmlfont,
                htmlfont+13,2)])
        self.html.SetRelatedFrame(self, "%s")
        button = wx.Button(self, wx.ID_OK)
        button.SetDefault()
        self.printer = wx.html.HtmlEasyPrinting()
        self.printer.SetFonts('', '', [i for i in range(htmlprintfont,
            htmlprintfont+13, 2)])
        self.printdata = self.printer.GetPrintData()
        self.printdata.SetColour(False)
        self.Bind(wx.EVT_BUTTON, self.OnQuit, button)
        self.Bind(wx.EVT_CHAR, self.OnChar)
        self.html.Bind(wx.EVT_CHAR, self.OnChar)
        self.cal_advance = 0
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.html, 1, wx.EXPAND | wx.ALL, 4)
        sizer.Add(button, 0, wx.ALIGN_CENTER | wx.BOTTOM, 4)
        self.SetSizer(sizer)
        self.Layout()
        self.show_cal()
        
    def SetPage(self, html):
        self.page = html
        self.html.SetPage(html)

    def OnChar(self, event):
        keycode = event.GetKeyCode()
        if keycode in [17, 27]:     # Ctrl-Q, Escape quit
            self.OnQuit(event)
        elif keycode == 16:         # Ctrl-P print
            self.OnPrint(event)
        elif keycode in [wx.WXK_UP]:
            self.cal_advance -= 1
            self.show_cal()
        elif keycode in [wx.WXK_DOWN]:
            self.cal_advance += 1
            self.show_cal()
        elif keycode in [wx.WXK_HOME]:
            self.cal_advance = 0
            self.show_cal()
        else:
            event.Skip()
            
    def show_cal(self):
        if self.cal_advance < 0:
            color = cal_pastcolor
        elif self.cal_advance == 0:
            color = cal_currentcolor
        else:
            color = cal_futurecolor
        html = """\
<title>etm calendar</title>
<body text="%s" bgcolor="%s">
<pre>
%s</pre><em>Up/down arrow keys: previous/next year<br>
Home key: current year</em> <br>
Ctrl-Q: close calendar
</body
""" % (main_fgcolor, color,  "\n".join(cal(self.cal_advance)))
        # self.html = html
        # self.prnt = html
        self.SetPage(html)
        self.Refresh()
            

    def OnPrint(self, event):
        self.printer.SetHeader(
          '<center><font size="+1">%s</font></center>' %
          self.html.GetOpenedPageTitle())
        self.printer.SetFooter(
                '<center>Page @PAGENUM@ of @PAGESCNT@</center>')
        self.printer.PrintText(self.page)


    def OnQuit(self,event):
        self.Destroy()


class App(wx.App):
    def OnInit(self):
        self.frame = ETM12cal()
        self.frame.Show(True)
        self.SetTopWindow(self.frame)
        return True
        
def main1():
    app = App(redirect=False)
    app.MainLoop()

def main2():
    app = wx.App()
    dialog = ETMcal()
    result = dialog.ShowModal()
    if result == wx.ID_OK and dialog.selecteddate:
        return dialog.selecteddate
    else:
        return result


if __name__ == '__main__':
    main1()
    res = main2()
    print res