//#define DEBUG 0

#define CONFIGFILE ".config/gsshfs"
//config file format: one connection per line: "host:port:username:directory:mountpoint"


enum { //connections's TreeView columns
	HOST,
	PORT,
	USERNAME,
	DIRECTORY,
	MOUNTPOINT,
	MOUNTED,
	COLUMNS_COUNT
};

void define_connections_model ();

gboolean is_mounted (gchar *host, gchar *username, gchar *directory, gchar **mounts);

gchar **load_mounts ();

void load_connections ();

void save_connections ();

void mount_connection (GtkWidget *widget, gpointer user_data);

void umount_connection (GtkWidget *widget, gpointer user_data);

void add_connection (GtkWidget *widget, gpointer user_data);

void remove_connection (GtkWidget *widget, gpointer user_data);

gboolean on_connection_change (	GtkTreeSelection	*selection,
							GtkTreeModel		*connections_model,
							GtkTreePath		*path,
							gboolean			path_currently_selected,
							gpointer			userdata);

void on_cell_edited (	GtkCellRendererText	*cell,
					gchar				*path_string,
					gchar				*new_text,
					gpointer				user_data);

gboolean check_server_key (gchar *host);

void sshfscommandfinished (GPid pid, gint status, gpointer data);