#include <gtk/gtk.h>
#include <unistd.h>
#include <libintl.h>
#include <locale.h>
#define _(String) gettext (String)
#define N_(String) String
#include <string.h>
#include "config.h"

#include "gsshfs-askpass.h"

void submitpassword (GtkWidget *widget, gpointer user_data) {
	GtkEntry *password;
	
	password = (GtkEntry *) gtk_builder_get_object (widgetstree, "password");
	g_print ("%s\n", gtk_entry_get_text (password));
	gtk_main_quit();
}


void cancelsshfs (GtkWidget *widget, gpointer user_data) {
	GtkLabel *host;
	gchar *psoutput;
	gchar **cmds;
	gchar *command;
	gchar *delimiter = "\n";
	gint i;
	gchar *hostptr;
	
	host = (GtkLabel *) gtk_builder_get_object (widgetstree, "host");
	
	g_spawn_command_line_sync ("ps -o pid,args -C ssh", &psoutput, NULL, NULL, NULL);
	cmds = g_strsplit (psoutput, delimiter, 0);
	for (i = 0; i < g_strv_length (cmds); i++) {
		hostptr = cmds[i] + 55; //beginning of host string in "ps -o pid,args" output
		cmds[i][5] = '\0'; //end of pid string
		if (0 == g_ascii_strncasecmp (hostptr, gtk_label_get_text (host), strlen (gtk_label_get_text (host)) - 1)) {
			command = g_strdup_printf ("kill %s", cmds[i]);
			g_spawn_command_line_sync (command, NULL, NULL, NULL, NULL);
			g_free (command);
		}
	}
	g_strfreev (cmds);
	g_free (psoutput);
	gtk_main_quit();
}


void viewpasswordtoggle (GtkWidget *widget, gpointer user_data) {
	GtkEntry *password;
	GtkCheckButton *viewpassword;
	
	password = (GtkEntry *) gtk_builder_get_object (widgetstree, "password");
	viewpassword = (GtkCheckButton *) gtk_builder_get_object (widgetstree, "viewpassword");
	
	if (visiblepassword) {
		gtk_entry_set_visibility (password, FALSE);
	} else {
		gtk_entry_set_visibility (password, TRUE);
	}
	visiblepassword = ! visiblepassword;
}


int main (int argc, char *argv[]) {
	GtkWindow *mainwindow;
	GtkLabel *host;
	gchar line[81];
	gint i;
	
	setlocale (LC_ALL, "");
	bindtextdomain (PROJECT_NAME, LOCALE_DIR);
	textdomain (PROJECT_NAME);

	if (argc > 1) {
		for (i = 0; argv[1][i] != '\'' && i < strlen (argv[1]); i++);
			argv[1][i] = '\0';
		
		gtk_init (&argc, &argv);
		widgetstree = gtk_builder_new();
		gtk_builder_add_from_file (widgetstree, ASKPASS_UI_FILE, NULL);
		gtk_builder_connect_signals (widgetstree, NULL);
		
		host = (GtkLabel *) gtk_builder_get_object (widgetstree, "host");
		gtk_label_set_text (host, argv[1]);
		
		mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
		gtk_window_set_icon_from_file (mainwindow, APP_ICON, NULL);
		gtk_widget_show ((GtkWidget *) mainwindow);
		gtk_main();
		return 0;
	} else {
		return 1;
	}
}
