#include <gtk/gtk.h>
#include <sys/types.h>
#include <unistd.h>
#include <libintl.h>
#include <locale.h>
#define _(String) gettext (String)
#define N_(String) String
#include "config.h"

#include "gsshfs.h"
#include "connections.h"


void on_clipboardcut_activate (GtkWidget *widget, gpointer user_data) {
        GtkWindow *mainwindow;
	GtkEntry *focusedentry;
	mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
        focusedentry = (GtkEntry *) gtk_window_get_focus (mainwindow);
        gtk_editable_cut_clipboard ((GtkEditable *) focusedentry);
}
void on_clipboardcopy_activate (GtkWidget *widget, gpointer user_data) {
        GtkWindow *mainwindow;
	GtkEntry *focusedentry;
	mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
        focusedentry = (GtkEntry *) gtk_window_get_focus (mainwindow);
        gtk_editable_copy_clipboard ((GtkEditable *) focusedentry);
}
void on_clipboardpaste_activate (GtkWidget *widget, gpointer user_data) {
        GtkWindow *mainwindow;
	GtkEntry *focusedentry;
	mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
        focusedentry = (GtkEntry *) gtk_window_get_focus (mainwindow);
        gtk_editable_paste_clipboard ((GtkEditable *) focusedentry);
}
void on_clipboarddelete_activate (GtkWidget *widget, gpointer user_data) {
        GtkWindow *mainwindow;
	GtkEntry *focusedentry;
	mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
        focusedentry = (GtkEntry *) gtk_window_get_focus (mainwindow);
        gtk_editable_delete_selection ((GtkEditable *) focusedentry);
}


void add_connections_treeview_columns () {
	GtkTreeView *view;
	GtkTreeSelection  *selection;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	
	view = (GtkTreeView *) gtk_builder_get_object (widgetstree, "connections");
	
	selection = gtk_tree_view_get_selection (view);
	gtk_tree_selection_set_select_function (selection, on_connection_change, NULL, NULL);
	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", TRUE, NULL);
	g_signal_connect (renderer, "edited", (GCallback) on_cell_edited, GINT_TO_POINTER (HOST));
	column = gtk_tree_view_column_new_with_attributes (gettext ("Host"), renderer, "text", HOST, NULL);
	gtk_tree_view_append_column (view, column);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", TRUE, NULL);
	g_signal_connect (renderer, "edited", (GCallback) on_cell_edited, GINT_TO_POINTER (PORT));
	column = gtk_tree_view_column_new_with_attributes (gettext ("Port"), renderer, "text", PORT, NULL);
	gtk_tree_view_append_column (view, column);
	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", TRUE, NULL);
	g_signal_connect (renderer, "edited", (GCallback) on_cell_edited, GINT_TO_POINTER (USERNAME));
	column = gtk_tree_view_column_new_with_attributes (gettext ("Username"), renderer, "text", USERNAME, NULL);
	gtk_tree_view_append_column (view, column);
	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", TRUE, NULL);
	g_signal_connect (renderer, "edited", (GCallback) on_cell_edited, GINT_TO_POINTER (DIRECTORY));
	column = gtk_tree_view_column_new_with_attributes (gettext ("Directory"), renderer, "text", DIRECTORY, NULL);
	gtk_tree_view_append_column (view, column);
	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "editable", TRUE, NULL);
	g_signal_connect (renderer, "edited", (GCallback) on_cell_edited, GINT_TO_POINTER (MOUNTPOINT));
	column = gtk_tree_view_column_new_with_attributes (gettext ("Mount point"), renderer, "text", MOUNTPOINT, NULL);
	gtk_tree_view_append_column (view, column);
	
	renderer = gtk_cell_renderer_toggle_new ();
	column = gtk_tree_view_column_new_with_attributes (gettext ("Mounted"), renderer, "active", MOUNTED, NULL);
	gtk_tree_view_append_column (view, column);
}


void on_statusicon_activated (GtkWidget *widget, gpointer user_data) {
	GtkWidget *mainwindow;
	GdkWindowState  state;
	
	mainwindow = (GtkWidget *) gtk_builder_get_object (widgetstree, "mainwindow");
	state = gdk_window_get_state (mainwindow->window);
	if (GDK_WINDOW_STATE_ICONIFIED == state) {
		gtk_window_deiconify ((GtkWindow *) mainwindow);
	} else {
		gtk_window_iconify ((GtkWindow *) mainwindow);
	}
}


void on_mainwindow_delete_event (GtkWidget *widget, gpointer user_data) {
	GtkWindow *mainwindow;

	mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
	gtk_window_iconify (mainwindow);
}


void display_error (const gchar *message) {
	GtkMessageDialog *errordialog;
	
	errordialog = (GtkMessageDialog *) gtk_builder_get_object (widgetstree, "errordialog");
	gtk_message_dialog_set_markup (errordialog, message);
	gtk_widget_show ((GtkWidget *) errordialog);
}


void on_quit (GtkWidget *widget, gpointer user_data) {
	GtkMessageDialog *quitdialog;
	gchar *lockfile;
	
	if (edited) {
		quitdialog = (GtkMessageDialog *) gtk_builder_get_object (widgetstree, "quitdialog");
		if (GTK_RESPONSE_YES == gtk_dialog_run ((GtkDialog *) quitdialog))
			save_connections();
	}
	
	lockfile = g_strdup_printf("%s/.gsshfs.lock", g_getenv("HOME"));
	g_unlink(lockfile);
	g_free(lockfile);
	
	gtk_main_quit();
}


int main (int argc, char *argv[]) {
	GtkWindow *mainwindow;
	GtkAboutDialog *aboutdialog;
	GtkStatusIcon *statusicon;
	gboolean isrunning;
	gchar *lockfile, *mypid, *runningpid, *runningpidpath;
	
	isrunning = FALSE;
	lockfile = g_strdup_printf("%s/.gsshfs.lock", g_getenv("HOME"));
	g_file_get_contents (lockfile, &runningpid, NULL, NULL);
	g_free(lockfile);
	if (NULL != runningpid) {
		runningpidpath = g_strdup_printf("/proc/%s", runningpid);
		g_free(runningpid);
		if (g_file_test(runningpidpath, G_FILE_TEST_IS_DIR)) {
			isrunning = TRUE;
		}
		g_free(runningpidpath);
	}
	
	if (! isrunning) {
		mypid = g_strdup_printf("%d", getpid());
		lockfile = g_strdup_printf("%s/.gsshfs.lock", g_getenv("HOME"));
		g_file_set_contents (lockfile, mypid, -1, NULL);
		g_free(lockfile);
		g_free(mypid);
		
		setlocale (LC_ALL, "");
		bindtextdomain (PROJECT_NAME, LOCALE_DIR);
		textdomain (PROJECT_NAME);
		
		gtk_init (&argc, &argv);
		widgetstree = gtk_builder_new();
		gtk_builder_add_from_file (widgetstree, UI_FILE, NULL);
		gtk_builder_connect_signals (widgetstree, NULL);
		
		add_connections_treeview_columns(); //Glade can't handle this
		define_connections_model ();
		load_connections();
		
		statusicon = gtk_status_icon_new_from_file (APP_ICON);
		g_signal_connect (statusicon, "activate", (GCallback) on_statusicon_activated, NULL);
		g_signal_connect (statusicon, "popup-menu", (GCallback) on_quit, NULL); //TODO: use a context menu
		edited = FALSE;
		
		mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
		gtk_window_set_icon_from_file (mainwindow, APP_ICON, NULL);
		aboutdialog = (GtkAboutDialog *) gtk_builder_get_object (widgetstree, "aboutdialog");
		gtk_about_dialog_set_version (aboutdialog, PROJECT_VERSION);
		gtk_widget_show ((GtkWidget *) mainwindow);
		gtk_main();
	}
	
	return 0;
}
