/*
 * gst-filter.h - Header for GstFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GST_FILTER_H__
#define __GST_FILTER_H__

#include <gst/gst.h>


G_BEGIN_DECLS
#define GST_TYPE_FILTER                         \
  (gst_filter_get_type())
#define GST_FILTER(obj)                         \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),           \
      GST_TYPE_FILTER,                          \
      GstFilter))
#define GST_FILTER_CLASS(klass)                 \
  (G_TYPE_CHECK_CLASS_CAST ((klass),            \
      GST_TYPE_FILTER,                          \
      GstFilterClass))
#define GST_IS_FILTER(obj)                      \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           \
      GST_TYPE_FILTER))
#define GST_IS_FILTER_CLASS(klass)              \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),            \
      GST_TYPE_FILTER))
#define GST_FILTER_GET_CLASS(obj)               \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),            \
      GST_TYPE_FILTER,                          \
      GstFilterClass))

typedef struct _GstFilter GstFilter;
typedef struct _GstFilterClass GstFilterClass;
typedef struct _GstFilterPrivate GstFilterPrivate;

/**
 * GstFilterClass:
 * @parent_class: The parent class
 * @apply: Apply the filter on the #GstPad
 * @revert: Revert the filter from the #GstPad
 * @handle_message: Handle the #GstMessage
 * @name: The name of the filter
 *
 * The base class for all filters. You must derive from this class and implement
 * the @apply and @revert methods as well as define the @name variable.
 * Implementing the @handle_message method is optional.
 */
struct _GstFilterClass
{
  GObjectClass parent_class;
  GstPad *(*apply) (GstFilter * self, GstBin * bin, GstPad * pad);
  GstPad *(*revert) (GstFilter * self, GstBin * bin, GstPad * pad);
    gboolean (*handle_message) (GstFilter * self, GstMessage * message);
  const gchar *name;
};

/**
 * GstFilter:
 *
 * A Filter
 */
struct _GstFilter
{
  GObject parent;
  GMutex *lock;
  /*< private > */
  GstFilterPrivate *priv;
};

GType
gst_filter_get_type (void)
    G_GNUC_CONST;

GstPad *gst_filter_apply (GstFilter * self, GstBin * bin, GstPad * pad);
GstPad *gst_filter_revert (GstFilter * self, GstBin * bin, GstPad * pad);
GstPad *gst_filter_follow (GstFilter * self, GstPad * pad);
gboolean gst_filter_handle_message (GstFilter * self, GstMessage * message);

G_END_DECLS
#endif /* __GST_FILTER_H__ */
