/*
 * gst-gnome-effect-filter.h - Header for GstGnomeEffectFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GST_GNOME_EFFECT_FILTER_H__
#define __GST_GNOME_EFFECT_FILTER_H__

#include <gst/filters/gst-filter.h>


G_BEGIN_DECLS
#define GST_TYPE_GNOME_EFFECT_FILTER                 \
  (gst_gnome_effect_filter_get_type())
#define GST_GNOME_EFFECT_FILTER(obj)                 \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),           \
      GST_TYPE_GNOME_EFFECT_FILTER,                  \
      GstGnomeEffectFilter))
#define GST_GNOME_EFFECT_FILTER_CLASS(klass)         \
  (G_TYPE_CHECK_CLASS_CAST ((klass),            \
      GST_TYPE_GNOME_EFFECT_FILTER,                  \
      GstGnomeEffectFilterClass))
#define GST_IS_GNOME_EFFECT_FILTER(obj)              \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           \
      GST_TYPE_GNOME_EFFECT_FILTER))
#define GST_IS_GNOME_EFFECT_FILTER_CLASS(klass)      \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),            \
      GST_TYPE_GNOME_EFFECT_FILTER))
#define GST_GNOME_EFFECT_FILTER_GET_CLASS(obj)       \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),            \
      GST_TYPE_GNOME_EFFECT_FILTER,                  \
      GstGnomeEffectFilterClass))

/**
 * GstGnomeEffectCategoriesGList:
 *
 * A #GList of strings representing the categories of the Gnome Video Effect.
 */
typedef GList GstGnomeEffectCategoriesGList;

#define GST_TYPE_GNOME_EFFECT_CATEGORIES_LIST \
  (gst_gnome_effect_categories_list_get_type ())

typedef struct _GstGnomeEffectFilter GstGnomeEffectFilter;
typedef struct _GstGnomeEffectFilterClass GstGnomeEffectFilterClass;
typedef struct _GstGnomeEffectFilterPrivate GstGnomeEffectFilterPrivate;

struct _GstGnomeEffectFilterClass
{
  GstFilterClass parent_class;
};

/**
 * GstGnomeEffectFilter:
 *
 * A Gnome Video Effect filter
 */
struct _GstGnomeEffectFilter
{
  GstFilter parent;
  /*< private > */
  GstGnomeEffectFilterPrivate *priv;
};

GType
gst_gnome_effect_filter_get_type (void)
  G_GNUC_CONST;
GType gst_gnome_effect_categories_list_get_type (void);

GstGnomeEffectFilter *gst_gnome_effect_filter_new (const gchar * filename,
    GError ** error);

void gst_gnome_effect_categories_list_destroy (GList * categories_list);
GList *gst_gnome_effect_categories_list_copy (const GList *
    categories_list);
GList *gst_gnome_effect_list_effects (const gchar * directory);
void gst_gnome_effect_effects_list_destroy (GList * effects_list);

G_END_DECLS
#endif /* __GST_GNOME_EFFECT_FILTER_H__ */
