/*
 * gst-maxframerate-filter.h - Header for GstMaxFramerateFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GST_MAXFRAMERATE_FILTER_H__
#define __GST_MAXFRAMERATE_FILTER_H__

#include <gst/filters/gst-filter.h>


G_BEGIN_DECLS
#define GST_TYPE_MAXFRAMERATE_FILTER              \
  (gst_maxframerate_filter_get_type())
#define GST_MAXFRAMERATE_FILTER(obj)              \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),           \
      GST_TYPE_MAXFRAMERATE_FILTER,               \
      GstMaxFramerateFilter))
#define GST_MAXFRAMERATE_FILTER_CLASS(klass)      \
  (G_TYPE_CHECK_CLASS_CAST ((klass),            \
      GST_TYPE_MAXFRAMERATE_FILTER,               \
      GstMaxFramerateFilterClass))
#define GST_IS_MAXFRAMERATE_FILTER(obj)           \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           \
      GST_TYPE_MAXFRAMERATE_FILTER))
#define GST_IS_MAXFRAMERATE_FILTER_CLASS(klass)   \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),            \
      GST_TYPE_MAXFRAMERATE_FILTER))
#define GST_MAXFRAMERATE_FILTER_GET_CLASS(obj)    \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),            \
      GST_TYPE_MAXFRAMERATE_FILTER,               \
      GstMaxFramerateFilterClass))
typedef struct _GstMaxFramerateFilter GstMaxFramerateFilter;
typedef struct _GstMaxFramerateFilterClass GstMaxFramerateFilterClass;
typedef struct _GstMaxFramerateFilterPrivate GstMaxFramerateFilterPrivate;

struct _GstMaxFramerateFilterClass
{
  GstFilterClass parent_class;
};

/**
 * GstMaxFramerateFilter:
 *
 * A video maxframerate filter
 */
struct _GstMaxFramerateFilter
{
  GstFilter parent;
  /*< private > */
  GstMaxFramerateFilterPrivate *priv;
};

GType
gst_maxframerate_filter_get_type (void)
    G_GNUC_CONST;

     GstMaxFramerateFilter *gst_maxframerate_filter_new (guint fps);

G_END_DECLS
#endif /* __GST_MAXFRAMERATE_FILTER_H__ */
