/*
 * gst-multi-filter-manager.h - Header for GstMultiFilterManager
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GST_MULTI_FILTER_MANAGER_H__
#define __GST_MULTI_FILTER_MANAGER_H__

#include <gst/filters/gst-filter-manager.h>


G_BEGIN_DECLS
#define GST_TYPE_MULTI_FILTER_MANAGER           \
  (gst_multi_filter_manager_get_type())
#define GST_MULTI_FILTER_MANAGER(obj)           \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),           \
      GST_TYPE_MULTI_FILTER_MANAGER,            \
      GstMultiFilterManager))
#define GST_MULTI_FILTER_MANAGER_CLASS(klass)   \
  (G_TYPE_CHECK_CLASS_CAST ((klass),            \
      GST_TYPE_MULTI_FILTER_MANAGER,            \
      GstMultiFilterManagerClass))
#define GST_IS_MULTI_FILTER_MANAGER(obj)        \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           \
      GST_TYPE_MULTI_FILTER_MANAGER))
#define GST_IS_MULTI_FILTER_MANAGER_CLASS(klass)        \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                    \
      GST_TYPE_MULTI_FILTER_MANAGER))
#define GST_MULTI_FILTER_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),            \
      GST_TYPE_MULTI_FILTER_MANAGER,            \
      GstMultiFilterManagerClass))
typedef struct _GstMultiFilterManager GstMultiFilterManager;
typedef struct _GstMultiFilterManagerClass GstMultiFilterManagerClass;
typedef struct _GstMultiFilterManagerPrivate GstMultiFilterManagerPrivate;

struct _GstMultiFilterManagerClass
{
  GObjectClass parent_class;
};

/**
 * GstMultiFilterManager:
 *
 * A filter manager that can be applied multiple times
 */
struct _GstMultiFilterManager
{
  GObject parent;
  /*< private > */
  GstMultiFilterManagerPrivate *priv;
};

GType
gst_multi_filter_manager_get_type (void)
    G_GNUC_CONST;

     GstFilterManager *gst_multi_filter_manager_new (void);

G_END_DECLS
#endif /* __GST_MULTI_FILTER_MANAGER_H__ */
