/*
 * gst-videosize-filter.h - Header for GstVideoSizeFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GST_VIDEOSIZE_FILTER_H__
#define __GST_VIDEOSIZE_FILTER_H__

#include <gst/filters/gst-filter.h>


G_BEGIN_DECLS
#define GST_TYPE_VIDEOSIZE_FILTER              \
  (gst_videosize_filter_get_type())
#define GST_VIDEOSIZE_FILTER(obj)              \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),           \
      GST_TYPE_VIDEOSIZE_FILTER,               \
      GstVideoSizeFilter))
#define GST_VIDEOSIZE_FILTER_CLASS(klass)      \
  (G_TYPE_CHECK_CLASS_CAST ((klass),            \
      GST_TYPE_VIDEOSIZE_FILTER,               \
      GstVideoSizeFilterClass))
#define GST_IS_VIDEOSIZE_FILTER(obj)           \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           \
      GST_TYPE_VIDEOSIZE_FILTER))
#define GST_IS_VIDEOSIZE_FILTER_CLASS(klass)   \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),            \
      GST_TYPE_VIDEOSIZE_FILTER))
#define GST_VIDEOSIZE_FILTER_GET_CLASS(obj)    \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),            \
      GST_TYPE_VIDEOSIZE_FILTER,               \
      GstVideoSizeFilterClass))
typedef struct _GstVideoSizeFilter GstVideoSizeFilter;
typedef struct _GstVideoSizeFilterClass GstVideoSizeFilterClass;
typedef struct _GstVideoSizeFilterPrivate GstVideoSizeFilterPrivate;

struct _GstVideoSizeFilterClass
{
  GstFilterClass parent_class;
};

/**
 * GstVideoSizeFilter:
 *
 * A filter to force the size of a video stream (resolution)
 */
struct _GstVideoSizeFilter
{
  GstFilter parent;
  /*< private > */
  GstVideoSizeFilterPrivate *priv;
};

GType gst_videosize_filter_get_type (void) G_GNUC_CONST;

GstVideoSizeFilter *gst_videosize_filter_new (guint width, guint height);

GstVideoSizeFilter *gst_videosize_filter_new_range (guint min_width,
    guint min_height, guint max_width, guint max_height);


G_END_DECLS
#endif /* __GST_VIDEOSIZE_FILTER_H__ */
