/*
 *      EasyPMP [CUI] device information.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or visit
 * http://www.gnu.org/copyleft/gpl.html .
 *
 */

/* $Id: device.c 341 2007-02-11 17:51:07Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>
#include <pmplib/filepath.h>
#include <pmplib/pmp.h>

#include "util.h"

/**
 * \addtogroup cui
 * @{
 */

// Display a path name using the given string format.
void device_show_path(FILE *fp, const char* const format, const ucs2char_t* const path)
{
	ucs2char_t decoded_path[MAX_PATH];
	ucs2cpy(decoded_path, path);
	filepath_decode(decoded_path);

	fprints(fp, format, decoded_path); 
}

void device_show_information(pmp_t* pmp, FILE *fp)
{
	int i;

	fprintf(fp, "Device identifier: %s\n", pmp->info.decl.id);
	fprintf(fp, "  Manufacturer: %s\n", pmp->info.decl.manufacturer);
	fprintf(fp, "  Product name: %s\n", pmp->info.decl.name);
	fprintf(fp, "  Firmware mode: %s\n", pmp->info.decl.mode);
	fprintf(fp, "  Firmware version: %s\n", pmp->info.decl.version);
	fprintf(fp, "  Firmware range: %s to %s\n", pmp->info.decl.min_version, pmp->info.decl.max_version);
	fprintf(fp, "  Default language: %s\n", pmp->info.decl.language);

	fprintf(fp, "  Audio codec(s): ");
	for (i = 0;i < pmp->info.num_audio_codecs;++i) {
		switch (pmp->info.audio_codecs[i]) {
		case PMPCODEC_MPEGLAYER3:	fputs("MP3", fp);		break;
		case PMPCODEC_WMA:			fputs("WMA", fp);		break;
		case PMPCODEC_VORBIS:		fputs("Ogg Vorbis", fp);	break;
		case PMPCODEC_WAV:			fputs("WAV", fp);		break;
		}
		if (i != pmp->info.num_audio_codecs-1)	fputs(", ", fp);
	}
	fputc('\n', fp);

	fprintf(fp, "  Audio extension(s): ");
	for (i = 0;i < pmp->info.num_audio_extensions;++i) {
		fprints(fp, "%s", pmp->info.audio_extensions[i]);
		if (i != pmp->info.num_audio_extensions-1)	fputs(";", fp);
	}
	fputc('\n', fp);

	fprints(fp, "  Root directory: %s\n", pmp->info.path_to_root);
	device_show_path(fp, "  Music directory: %s\n", pmp->info.path_to_music);
	device_show_path(fp, "  Playlist directory: %s\n", pmp->info.path_to_playlist);
}

static void enumerate_devid_callback(void *instance, const char *devid)
{
	pmplib_t *pmplib = (pmplib_t*)instance;
	pmp_t* pmp = NULL;
	ucs2char_t ucs2cs_empty[] = {0};

	pmplib_create(pmplib, &pmp, ucs2cs_empty, devid);
	device_show_information(pmp, stdout);
	fprintf(stdout, "\n");
	pmp->release(pmp);
}

void device_enumerate(pmplib_t* pmplib)
{
	pmplib_enumerate_devid(pmplib, enumerate_devid_callback, pmplib);
}
/** @} */
