/*
 *      M3U/M3U8 playlist routine.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: rw_m3u.c 328 2007-02-10 17:50:11Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef	HAVE_STRING_H
#include <string.h>
#endif/*HAVE_STRING_H*/
#include <pmplib/ucs2char.h>
#include <playlist.h>

static char *strip(char *line)
{
	char *p = line;
	while (*p && *p != '\n' && *p != '\r') {
		p++;
	}
	*p = 0;

	return line;
}

int playlist_m3u_read(playlists_t* pls, const ucs2char_t *filename, int is_utf8)
{
	FILE *fp = ucs2fopen(filename, "r");
	if (!fp) {
		return -1;
	} else {
		unsigned char *p = NULL;
		char line[MAX_PATH * 8];
		int lines = 0;
		playlist_t* pl = calloc(1, sizeof(playlist_t));

		pl->entries = 0;
		pl->num_entries = 0;
		ucs2cpy(pl->name, filename);

		while (fgets(line, sizeof(line)-1, fp) != NULL) {
			strip(line);

			p = (unsigned char *)line;
			if (lines == 0) {
				/* Skip UTF-8 BOM if any. */
				if (strlen((char *)p) > 3) {
					if (p[0] == 0xEF && p[1] == 0xBB && p[2] == 0xBF) {
						p += 3;
						is_utf8 = 1;
					}
				}
			}
			++lines;

			if (p[0] == 0 || p[0] == '#') {
				continue;
			}

			pl->entries = (playlist_entry_t*)realloc(pl->entries, sizeof(playlist_entry_t) * (pl->num_entries+1));
			if (is_utf8) {
				utf8toucs2(
					pl->entries[pl->num_entries].filename,
					sizeof(pl->entries[pl->num_entries].filename),
					(char *)p,
					strlen((char *)p)+1
					);
			} else {
				mbstoucs2(
					pl->entries[pl->num_entries].filename,
					sizeof(pl->entries[pl->num_entries].filename),
					line,
					strlen(line)+1
					);
			}
			pl->entries[pl->num_entries].valid = 1;
			pl->entries[pl->num_entries].order = pl->num_entries;
			pl->num_entries++;
		}

		fclose(fp);

		pls->playlists = pl;
		pls->num_playlists = 1;

		return 0;
	}
}

