/*
 *      Data serializer (with byte-order consideration).
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: serialize.h 328 2007-02-10 17:50:11Z nyaochi $ */

#ifndef	__IP2DB_SERIALIZE_H__
#define	__IP2DB_SERIALIZE_H__

size_t serialize_uint8(uint8_t* buffer, uint8_t* value, int is_storing);
size_t serialize_uint8_array(uint8_t* buffer, uint8_t* array, size_t length, int is_storing);
size_t serialize_uint16le(uint8_t* buffer, uint16_t* value, int is_storing);
size_t serialize_uint32le(uint8_t* buffer, uint32_t* value, int is_storing);
size_t serialize_uint16be(uint8_t* buffer, uint16_t* value, int is_storing);
size_t serialize_uint32be(uint8_t* buffer, uint32_t* value, int is_storing);
size_t serialize_ucs2be(uint8_t* buffer, ucs2char_t* value, int is_storing);
size_t serialize_ucs2be_string_fixed(uint8_t* buffer, ucs2char_t* str, size_t length, int is_storing);
size_t serialize_ucs2be_string_var(uint8_t* buffer, ucs2char_t* str, int is_storing);
size_t serialize_ucs2be_string_var_alloc(uint8_t* buffer, ucs2char_t** str);

#endif/*__IP2DB_SERIALIZE_H__*/
