/*
 *      Sirius S50 specific routines and header templates.
 *
 *      Copyright (c) 2005-2007 Naoaki Okazaki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 */

/* $Id: model_sirius_s50.c 342 2007-02-11 18:11:43Z nyaochi $ */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif/*HAVE_CONFIG_H*/

#include <os.h>
#include <stdio.h>
#include <stdlib.h>
#include <pmplib/ucs2char.h>
#include <pmplib/filepath.h>

#include "serialize.h"
#include "util.h"
#include "pp1db.h"
#include "hdr_template.h"

enum {
	PP1DB_DATFIELD_UNKNOWN2 = 0,// @0:	(INT)	
	PP1DB_DATFIELD_PATHNAME,	// @1:	(STR)	
	PP1DB_DATFIELD_FILENAME,	// @2:	(STR)	
	PP1DB_DATFIELD_FORMAT,		// @3:	(INT)
	PP1DB_DATFIELD_BITRATE,		// @4:	(INT)
	PP1DB_DATFIELD_SAMPLERATE,	// @5:	(INT)
	PP1DB_DATFIELD_DURATION,	// @6:	(INT)
	PP1DB_DATFIELD_ARTIST,		// @7:	(STR)
	PP1DB_DATFIELD_ALBUM,		// @8:	(STR)
	PP1DB_DATFIELD_GENRE,		// @9:	(STR)
	PP1DB_DATFIELD_TITLE,		// @10:	(STR)
	PP1DB_DATFIELD_FILESIZE,	// @11:	(INT)
	PP1DB_DATFIELD_UNKNOWN3,	// @12: (INT)
	PP1DB_DATFIELD_DATETIME,	// @13: (STR)
	PP1DB_DATFIELD_UNKNOWN4,	// @14: (STR)
	PP1DB_DATFIELD_UNKNOWN5,	// @15: (STR)
	PP1DB_DATFIELD_UNKNOWN6,	// @16: (INT)
	PP1DB_DATFIELD_UNKNOWN7,	// @17: (INT)
	PP1DB_DATFIELD_UNKNOWN8,	// @18: (STR)
	PP1DB_DATFIELD_UNKNOWN9,	// @19: (STR)
	PP1DB_DATFIELD_UNKNOWN10,	// @20: (STR)
	PP1DB_DATFIELD_UNKNOWN11,	// @21: (INT)
	PP1DB_DATFIELD_UNKNOWN12,	// @22: (INT)
	PP1DB_DATFIELD_UNKNOWN13,	// @23: (INT)
	PP1DB_DATFIELD_UNKNOWN14,	// @24: (INT)
	PP1DB_DATFIELD_UNKNOWN15,	// @25: (INT)
};

void sirius_s50_dat_repr(const dat_t* record, FILE *fp)
{
	fprintf(fp, "  inactive: %d\n", record->status);
	fprintf(fp, "  unknown1: %d\n", record->unknown1);
	fprintf(fp, "  unknown2: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN2].value.dword);
	fprints(fp, "  file_path: %s\n", record->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	fprints(fp, "  file_name: %s\n", record->fields[PP1DB_DATFIELD_FILENAME].value.str);
	fprintf(fp, "  media_type: %d\n", record->fields[PP1DB_DATFIELD_FORMAT].value.dword);
	fprintf(fp, "  bitrate: %d\n", record->fields[PP1DB_DATFIELD_BITRATE].value.dword);
	fprintf(fp, "  samplerate: %d\n", record->fields[PP1DB_DATFIELD_SAMPLERATE].value.dword);
	fprintf(fp, "  duration: %d\n", record->fields[PP1DB_DATFIELD_DURATION].value.dword);
	fprints(fp, "  artist: %s\n", record->fields[PP1DB_DATFIELD_ARTIST].value.str);
	fprints(fp, "  album: %s\n", record->fields[PP1DB_DATFIELD_ALBUM].value.str);
	fprints(fp, "  genre: %s\n", record->fields[PP1DB_DATFIELD_GENRE].value.str);
	fprints(fp, "  title: %s\n", record->fields[PP1DB_DATFIELD_TITLE].value.str);
	fprintf(fp, "  filesize: %d\n", record->fields[PP1DB_DATFIELD_FILESIZE].value.dword);
	fprintf(fp, "  unknown3: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN3].value.dword);
	fprints(fp, "  datetime: %s\n", record->fields[PP1DB_DATFIELD_DATETIME].value.str);
	fprints(fp, "  unknown4: %s\n", record->fields[PP1DB_DATFIELD_UNKNOWN4].value.str);
	fprints(fp, "  unknown5: %s\n", record->fields[PP1DB_DATFIELD_UNKNOWN5].value.str);
	fprintf(fp, "  unknown6: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN6].value.dword);
	fprintf(fp, "  unknown7: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN7].value.dword);
	fprints(fp, "  unknown8: %s\n", record->fields[PP1DB_DATFIELD_UNKNOWN8].value.str);
	fprints(fp, "  unknown9: %s\n", record->fields[PP1DB_DATFIELD_UNKNOWN9].value.str);
	fprints(fp, "  unknown10: %s\n", record->fields[PP1DB_DATFIELD_UNKNOWN10].value.str);
	fprintf(fp, "  unknown11: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN11].value.dword);
	fprintf(fp, "  unknown12: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN12].value.dword);
	fprintf(fp, "  unknown13: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN13].value.dword);
	fprintf(fp, "  unknown14: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN14].value.dword);
	fprintf(fp, "  unknown15: %d\n", record->fields[PP1DB_DATFIELD_UNKNOWN15].value.dword);
}

int sirius_s50_dat_set(dat_t* dst, const pmp_music_record_t* src, const ucs2char_t* path_to_root)
{
	static const ucs2char_t ucs2cs_unknown[] = {0};
	static const ucs2char_t ucs2cs_empty[] = {0};

	// Set fields.
	dst->status = 0;
	dst->unknown1 = 0;
	dst->fields[PP1DB_DATFIELD_PATHNAME].value.str = ucs2dup(filepath_skiproot(src->filename, path_to_root));
	filepath_remove_filespec(dst->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	filepath_addslash(dst->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	filepath_encode(dst->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	dst->fields[PP1DB_DATFIELD_FILENAME].value.str = ucs2dup(filepath_skippath(src->filename));
	dst->fields[PP1DB_DATFIELD_FORMAT].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_BITRATE].value.dword = src->bitrate;
	dst->fields[PP1DB_DATFIELD_SAMPLERATE].value.dword = src->sample_rate;
	dst->fields[PP1DB_DATFIELD_DURATION].value.dword = src->duration;
	dst->fields[PP1DB_DATFIELD_ARTIST].value.str = ucs2dup(src->artist ? src->artist : ucs2cs_unknown);
	dst->fields[PP1DB_DATFIELD_ALBUM].value.str = ucs2dup(src->album ? src->album : ucs2cs_unknown);
	dst->fields[PP1DB_DATFIELD_GENRE].value.str = ucs2dup(src->genre ? src->genre : ucs2cs_unknown);
	dst->fields[PP1DB_DATFIELD_TITLE].value.str = ucs2dup(src->title ? src->title : dst->fields[PP1DB_DATFIELD_FILENAME].value.str);
	dst->fields[PP1DB_DATFIELD_FILESIZE].value.dword = src->filesize;
	dst->fields[PP1DB_DATFIELD_UNKNOWN3].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_DATETIME].value.str = ucs2dup(ucs2cs_empty);
	dst->fields[PP1DB_DATFIELD_UNKNOWN4].value.str = ucs2dup(ucs2cs_empty);
	dst->fields[PP1DB_DATFIELD_UNKNOWN5].value.str = ucs2dup(ucs2cs_empty);
	dst->fields[PP1DB_DATFIELD_UNKNOWN6].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_UNKNOWN7].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_UNKNOWN8].value.str = ucs2dup(ucs2cs_empty);
	dst->fields[PP1DB_DATFIELD_UNKNOWN9].value.str = ucs2dup(ucs2cs_empty);
	dst->fields[PP1DB_DATFIELD_UNKNOWN10].value.str = ucs2dup(ucs2cs_empty);
	dst->fields[PP1DB_DATFIELD_UNKNOWN11].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_UNKNOWN12].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_UNKNOWN13].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_UNKNOWN14].value.dword = 0;
	dst->fields[PP1DB_DATFIELD_UNKNOWN15].value.dword = 0;
	return 0;
}

int sirius_s50_dat_get(pmp_music_record_t* dst, const dat_t* src, const ucs2char_t* path_to_root)
{
	static const ucs2char_t ucs2cs_mp3[] = {'.','m','p','3',0};
	static const ucs2char_t ucs2cs_wma[] = {'.','w','m','a',0};
	static const ucs2char_t ucs2cs_wav[] = {'.','w','a','v',0};
	size_t length = 0;

	length  = ucs2len(path_to_root);
	length += ucs2len(src->fields[PP1DB_DATFIELD_PATHNAME].value.str);
	length += ucs2len(src->fields[PP1DB_DATFIELD_FILENAME].value.str);
	length += 3;

	dst->filename = (ucs2char_t*)ucs2malloc(sizeof(ucs2char_t) * length);
	if (dst->filename) {
		filepath_combinepath(dst->filename, length, path_to_root, src->fields[PP1DB_DATFIELD_PATHNAME].value.str);
		ucs2cat(dst->filename, src->fields[PP1DB_DATFIELD_FILENAME].value.str);
		filepath_decode(dst->filename);
	}

	dst->bitrate = src->fields[PP1DB_DATFIELD_BITRATE].value.dword;
	dst->sample_rate = src->fields[PP1DB_DATFIELD_SAMPLERATE].value.dword;
	dst->duration = src->fields[PP1DB_DATFIELD_DURATION].value.dword;

	dst->artist = ucs2dup(src->fields[PP1DB_DATFIELD_ARTIST].value.str);
	dst->album = ucs2dup(src->fields[PP1DB_DATFIELD_ALBUM].value.str);
	dst->genre = ucs2dup(src->fields[PP1DB_DATFIELD_GENRE].value.str);
	dst->title = ucs2dup(src->fields[PP1DB_DATFIELD_TITLE].value.str);

	// Set codec information according to the file extensions.
	if (filepath_hasext(dst->filename, ucs2cs_mp3)) {
		dst->codec = PMPCODEC_MPEGLAYER3;
	} else if (filepath_hasext(dst->filename, ucs2cs_wma)) {
		dst->codec = PMPCODEC_WMA;
	} else if (filepath_hasext(dst->filename, ucs2cs_wav)) {
		dst->codec = PMPCODEC_WAV;
	}

	dst->filesize = src->fields[PP1DB_DATFIELD_FILESIZE].value.dword;

	return 0;
}



static fd_template_t hdrtmpl_fd_s50[] = {
	{0x0000F001, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_@DEV.IDX"},
	{0x0000F002, 1, 256, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_FPTH.IDX"},
	{0x0000F003, 1, 256, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_FNAM.IDX"},
	{0x0000F00A, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_FRMT.IDX"},
	{0x0000F005, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000F006, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000F007, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000003C, 1, 256, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_TPE1.IDX"},
	{0x0000001C, 1, 256, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_TALB.IDX"},
	{0x0000001F, 1, 256, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_TCON.IDX"},
	{0x0000002E, 1, 256, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_TIT2.IDX"},
	{0x0000F009, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000E013, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_@U20.IDX"},
	{0x0000E014, 1,  15, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_@U21.IDX"},
	{0x0000001E, 1, 256, 0, 0, 0, 0, 0, ""},
	{0x0000E015, 1,  10, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_@U22.IDX"},
	{0x00000011, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_PCNT.IDX"},
	{0x0000E00A, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000E00B, 1, 256, 0, 0, 0, 0, 0, ""},
	{0x0000E00C, 1, 256, 0, 0, 0, 0, 0, ""},
	{0x0000E00E, 1,  40, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_@U15.IDX"},
	{0x0000E010, 2,   4, 0, 0, 1, 0, 0, "SYSTEM\\DB\\SONG\\Xena_@U17.IDX"},
	{0x00000040, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000E011, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000E012, 2,   4, 0, 0, 0, 0, 0, ""},
	{0x0000E009, 2,   4, 0, 0, 0, 0, 0, ""},
};

static uint32_t hdrtmpl_max_dat_field_size_s50[] =
	{8, 12, 524, 1036, 1040, 1044, 1048, 1052, 1564, 2076, 2588, 3100, 3104, 3108, 3138, 3650, 3670, 3674, 3678, 4190, 4702, 4782, 4786, 4790, 4794, 4798};


/********** H10 20GB MTP firmware 2.51 **********/
static hdr_template_t hdrtmpl_sirius_s50 = {
	0, 0, "SYSTEM\\DB\\SONG\\Xena.DAT", 0, "SYSTEM\\DB\\SONG\\Xena.HDR", 0x000012C2, 0, 0, 26,
	hdrtmpl_fd_s50,
	hdrtmpl_max_dat_field_size_s50,
	0, 1,
	{71312, 26, 1000, 0, 1, sirius_s50_dat_repr, sirius_s50_dat_set, sirius_s50_dat_get},
};
int hdr_init_sirius_s50(hdr_t* hdr)
{
	return apply_template(hdr, &hdrtmpl_sirius_s50);
}

