/*
 * gst-audioconverter-filter.c - Source for GstAudioconverterFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * SECTION:gst-audioconverter-filter
 * @short_description: An audio converter filter
 *
 * This filter will convert audio from one format to another.
 */


#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gst/filters/gst-audioconverter-filter.h>
#include <gst/filters/gst-filter-helper.h>


GST_DEFINE_FILTER (GstAudioconverterFilter, audioconverter);

static void
gst_audioconverter_filter_init (GstAudioconverterFilter * self)
{
}

/**
 * gst_audioconverter_filter_new:
 *
 * Creates a new audioconverter filter or reuse an existing one.
 * This filter will take care of converting audio from one format to another.
 * It will basically add 'audioconvert ! audioresample ! audioconvert'
 * to the pipeline.
 *
 * Returns: A new #GstAudioconverterFilter
 */
GstAudioconverterFilter *
gst_audioconverter_filter_new (void)
{
  static GstAudioconverterFilter *singleton = NULL;
  static GStaticMutex mutex = G_STATIC_MUTEX_INIT;

  g_static_mutex_lock (&mutex);
  if (!singleton) {
    singleton = g_object_new (GST_TYPE_AUDIOCONVERTER_FILTER, NULL);
    g_object_add_weak_pointer (G_OBJECT (singleton), (gpointer *) & singleton);
  } else {
    g_object_ref (singleton);
  }
  g_static_mutex_unlock (&mutex);

  return singleton;
}


static GstPad *
gst_audioconverter_filter_apply (GstFilter * filter, GstBin * bin, GstPad * pad)
{
  return gst_filter_apply_element_by_description (bin, pad,
      "audioconvert ! audioresample ! audioconvert", NULL, NULL);
}

static GstPad *
gst_audioconverter_filter_revert (GstFilter * filter,
    GstBin * bin, GstPad * pad)
{
  return gst_filter_revert_element_default (bin, pad, NULL);
}
