/*
 * gst-volume-filter.h - Header for GstVolumeFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GST_VOLUME_FILTER_H__
#define __GST_VOLUME_FILTER_H__

#include <gst/filters/gst-filter.h>


G_BEGIN_DECLS
#define GST_TYPE_VOLUME_FILTER                  \
  (gst_volume_filter_get_type())
#define GST_VOLUME_FILTER(obj)                  \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),           \
      GST_TYPE_VOLUME_FILTER,                   \
      GstVolumeFilter))
#define GST_VOLUME_FILTER_CLASS(klass)          \
  (G_TYPE_CHECK_CLASS_CAST ((klass),            \
      GST_TYPE_VOLUME_FILTER,                   \
      GstVolumeFilterClass))
#define GST_IS_VOLUME_FILTER(obj)               \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           \
      GST_TYPE_VOLUME_FILTER))
#define GST_IS_VOLUME_FILTER_CLASS(klass)       \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),            \
      GST_TYPE_VOLUME_FILTER))
#define GST_VOLUME_FILTER_GET_CLASS(obj)        \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),            \
      GST_TYPE_VOLUME_FILTER,                   \
      GstVolumeFilterClass))
typedef struct _GstVolumeFilter GstVolumeFilter;
typedef struct _GstVolumeFilterClass GstVolumeFilterClass;
typedef struct _GstVolumeFilterPrivate GstVolumeFilterPrivate;

struct _GstVolumeFilterClass
{
  GstFilterClass parent_class;
};


/**
 * GstVolumeFilter:
 *
 * An audio volume filter
 */
struct _GstVolumeFilter
{
  GstFilter parent;
  /*< private > */
  GstVolumeFilterPrivate *priv;
};

GType
gst_volume_filter_get_type (void)
    G_GNUC_CONST;

     GstVolumeFilter *gst_volume_filter_new (void);

G_END_DECLS
#endif /* __GST_VOLUME_FILTER_H__ */
