###############################################################################
# Name: matlabtags.py                                                         #
# Purpose: Generate Function lists for Matlab and Octave                      #
# Author: Cody Precord <cprecord@editra.org>                                  #
# Copyright: (c) 2008 Cody Precord <staff@editra.org>                         #
# License: wxWindows License                                                  #
###############################################################################

"""
FILE: matlabtags.py
AUTHOR: Cody Precord
LANGUAGE: Python
SUMMARY:
  Generate a DocStruct object that captures the structure of MatLab and Octave
document. Supports generating a listing of functions in the document.

"""

__author__ = "Cody Precord <cprecord@editra.org>"
__svnid__ = "$Id: matlabtags.py 52685 2008-03-22 06:41:10Z CJP $"
__revision__ = "$Revision: 52685 $"

#--------------------------------------------------------------------------#
# Dependancies
import taglib
import parselib

#--------------------------------------------------------------------------#

def GenerateTags(buff):
    """Create a DocStruct object that represents a MatLab/Octave document
    @param buff: a file like buffer object (StringIO)

    """
    rtags = taglib.DocStruct()
    rtags.SetElementDescription('function', "Function Definitions")

    # Do the parse
    for lnum, line in enumerate(buff):
        line = line.strip()

        # Skip comment and empty lines
        if line.startswith(u"%") or line.startswith(u"#") or not line:
            continue

        # Check Regular Function Defs
        if parselib.IsToken(line, 0, u'function'):
            name = parselib.GetFirstIdentifier(line[8:])
            if name is not None and len(name):
                rtags.AddFunction(taglib.Function(name, lnum))
            continue

    return rtags

#-----------------------------------------------------------------------------#
# Test
if __name__ == '__main__':
    import sys
    import StringIO
    fhandle = open(sys.argv[1])
    txt = fhandle.read()
    fhandle.close()
    tags = GenerateTags(StringIO.StringIO(txt))
    print "\n\nElements:"
    for element in tags.GetElements():
        print "\n%s:" % element.keys()[0]
        for val in element.values()[0]:
            print "%s [%d]" % (val.GetName(), val.GetLine())
    print "END"
