/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes;

import java.util.List;
import javax.swing.RepaintManager;
import net.sourceforge.atunes.ApplicationArguments;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.debug.CheckThreadViolationRepaintManager;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.instances.MultipleInstancesHandler;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Log4jPropertiesLoader;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

public final class Main {
    private static Logger logger;

    private Main() {
    }

    private static void logProgramProperties(List<String> list) {
        String string = StringUtils.getString("Starting ", "aTunes", " ", Constants.VERSION);
        Main.getLogger().info("START       ", string);
        Main.getLogger().info("START       ", StringUtils.getString("Running in Java Virtual Machine ", System.getProperty("java.version")));
        Main.getLogger().info("START       ", StringUtils.getString("Arguments = ", list));
        Main.getLogger().info("START       ", StringUtils.getString("Debug mode = ", Kernel.isDebug()));
        Main.getLogger().info("START       ", StringUtils.getString("Execution path = ", SystemProperties.getWorkingDirectory()));
    }

    public static void main(String[] stringArray) {
        List<String> list = StringUtils.fromStringArrayToList(stringArray);
        Kernel.setDebug(list.contains("debug"));
        ApplicationArguments.saveArguments(list);
        if (!list.contains("multiple-instance") && !MultipleInstancesHandler.getInstance().isFirstInstance()) {
            MultipleInstancesHandler.getInstance().sendArgumentsToFirstInstance(list);
        } else {
            Kernel.setIgnoreLookAndFeel(list.contains("ignore-look-and-feel"));
            Kernel.setNoUpdate(list.contains("no-update"));
            SystemProperties.setCustomConfigFolder(ApplicationArguments.getUserConfigFolder(list));
            SystemProperties.setCustomRepositoryConfigFolder(ApplicationArguments.getRepositoryConfigFolder(list));
            Log4jPropertiesLoader.loadProperties(Kernel.isDebug());
            try {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        Main.getLogger().error("UNEXPECTED ERROR", StringUtils.getString("Thread: ", thread.getName()));
                        Main.getLogger().error("UNEXPECTED ERROR", throwable);
                    }
                });
            }
            catch (Throwable throwable) {
                Main.getLogger().error("UNEXPECTED ERROR", throwable);
            }
            System.err.close();
            if (Kernel.isDebug()) {
                RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
            }
            Main.logProgramProperties(list);
            Kernel.startKernel(list);
        }
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }
}

