/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;

public class OSXAdapter
implements InvocationHandler {
    private Object targetObject;
    private Method targetMethod;
    private String proxySignature;
    private static Object macOSXApplication;
    private static Logger logger;

    public static void setQuitHandler(Object object, Method method) {
        OSXAdapter.setHandler(new OSXAdapter("handleQuit", object, method));
    }

    public static void setAboutHandler(Object object, Method method) {
        boolean bl;
        boolean bl2 = bl = object != null && method != null;
        if (bl) {
            OSXAdapter.setHandler(new OSXAdapter("handleAbout", object, method));
        }
        try {
            Method method2 = macOSXApplication.getClass().getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
            method2.invoke(macOSXApplication, bl);
        }
        catch (SecurityException securityException) {
            OSXAdapter.logAboutMenuException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            OSXAdapter.logAboutMenuException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSXAdapter.logAboutMenuException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            OSXAdapter.logAboutMenuException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            OSXAdapter.logAboutMenuException(invocationTargetException);
        }
    }

    private static void logAboutMenuException(Exception exception) {
        OSXAdapter.getLogger().error("DESKTOP     ", "OSXAdapter could not access the About Menu");
        OSXAdapter.getLogger().error("DESKTOP     ", exception);
    }

    public static void setPreferencesHandler(Object object, Method method) {
        boolean bl;
        boolean bl2 = bl = object != null && method != null;
        if (bl) {
            OSXAdapter.setHandler(new OSXAdapter("handlePreferences", object, method));
        }
        try {
            Method method2 = macOSXApplication.getClass().getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method2.invoke(macOSXApplication, bl);
        }
        catch (SecurityException securityException) {
            OSXAdapter.logPreferencesMenuException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            OSXAdapter.logPreferencesMenuException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSXAdapter.logPreferencesMenuException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            OSXAdapter.logPreferencesMenuException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            OSXAdapter.logPreferencesMenuException(invocationTargetException);
        }
    }

    private static void logPreferencesMenuException(Exception exception) {
        OSXAdapter.getLogger().error("DESKTOP     ", "OSXAdapter could not access the Preferences Menu");
        OSXAdapter.getLogger().error("DESKTOP     ", exception);
    }

    public static void setFileHandler(Object object, Method method) {
        OSXAdapter.setHandler(new FileHandlerOSXAdapter("handleOpenFile", object, method));
    }

    private static void logCallTargetException(String string, Exception exception) {
        OSXAdapter.getLogger().error("DESKTOP     ", StringUtils.getString("OSXAdapter could not handle file: ", string));
        OSXAdapter.getLogger().error("DESKTOP     ", exception);
    }

    public static void setHandler(OSXAdapter oSXAdapter) {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            if (macOSXApplication == null) {
                macOSXApplication = clazz.getConstructor(null).newInstance(null);
            }
            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = clazz.getDeclaredMethod("addApplicationListener", clazz2);
            Object object = Proxy.newProxyInstance(OSXAdapter.class.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)oSXAdapter);
            method.invoke(macOSXApplication, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            OSXAdapter.getLogger().error("DESKTOP     ", StringUtils.getString("This version of Mac OS X does not support the Apple EAWT.  ApplicationEvent handling has been disabled (", classNotFoundException, ")"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            OSXAdapter.logHandlerException(illegalArgumentException);
        }
        catch (SecurityException securityException) {
            OSXAdapter.logHandlerException(securityException);
        }
        catch (InstantiationException instantiationException) {
            OSXAdapter.logHandlerException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            OSXAdapter.logHandlerException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            OSXAdapter.logHandlerException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            OSXAdapter.logHandlerException(noSuchMethodException);
        }
    }

    private static void logHandlerException(Exception exception) {
        OSXAdapter.getLogger().error("DESKTOP     ", "Mac OS X Adapter could not talk to EAWT:");
        OSXAdapter.getLogger().error("DESKTOP     ", exception);
    }

    protected OSXAdapter(String string, Object object, Method method) {
        this.proxySignature = string;
        this.targetObject = object;
        this.targetMethod = method;
    }

    public boolean callTarget(Object object) throws InvocationTargetException, IllegalAccessException {
        Object object2 = this.targetMethod.invoke(this.targetObject, (Object[])null);
        if (object2 == null) {
            return true;
        }
        return Boolean.valueOf(object2.toString());
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        if (this.isCorrectMethod(method, objectArray)) {
            boolean bl = this.callTarget(objectArray[0]);
            this.setApplicationEventHandled(objectArray[0], bl);
        }
        return null;
    }

    protected boolean isCorrectMethod(Method method, Object[] objectArray) {
        return this.targetMethod != null && this.proxySignature.equals(method.getName()) && objectArray.length == 1;
    }

    protected void setApplicationEventHandled(Object object, boolean bl) {
        if (object != null) {
            try {
                Method method = object.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                method.invoke(object, bl);
            }
            catch (SecurityException securityException) {
                OSXAdapter.logApplicationEventException(object, securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                OSXAdapter.logApplicationEventException(object, noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                OSXAdapter.logApplicationEventException(object, illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                OSXAdapter.logApplicationEventException(object, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                OSXAdapter.logApplicationEventException(object, invocationTargetException);
            }
        }
    }

    private static void logApplicationEventException(Object object, Exception exception) {
        OSXAdapter.getLogger().error("DESKTOP     ", StringUtils.getString("OSXAdapter was unable to handle an ApplicationEvent: ", object));
        OSXAdapter.getLogger().error("DESKTOP     ", exception);
    }

    protected Object getTargetObject() {
        return this.targetObject;
    }

    protected Method getTargetMethod() {
        return this.targetMethod;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }

    private static final class FileHandlerOSXAdapter
    extends OSXAdapter {
        private FileHandlerOSXAdapter(String string, Object object, Method method) {
            super(string, object, method);
        }

        @Override
        public boolean callTarget(Object object) {
            if (object != null) {
                String string = null;
                try {
                    Method method = object.getClass().getDeclaredMethod("getFilename", null);
                    string = (String)method.invoke(object, (Object[])null);
                    this.getTargetMethod().invoke(this.getTargetObject(), string);
                }
                catch (SecurityException securityException) {
                    OSXAdapter.logCallTargetException(string, securityException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    OSXAdapter.logCallTargetException(string, noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    OSXAdapter.logCallTargetException(string, illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    OSXAdapter.logCallTargetException(string, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    OSXAdapter.logCallTargetException(string, invocationTargetException);
                }
            }
            return true;
        }
    }
}

