/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import net.sourceforge.atunes.gui.OSXAdapter;
import net.sourceforge.atunes.gui.frame.Frame;
import net.sourceforge.atunes.gui.frame.FrameState;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.bars.ToolBar;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.gui.views.dialogs.UpdateDialog;
import net.sourceforge.atunes.gui.views.menus.ApplicationMenuBar;
import net.sourceforge.atunes.gui.views.panels.AudioObjectPropertiesPanel;
import net.sourceforge.atunes.gui.views.panels.ContextPanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTablePanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTreePanel;
import net.sourceforge.atunes.gui.views.panels.PlayListPanel;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.updates.ApplicationVersion;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import org.jdesktop.swingx.JXStatusBar;

abstract class AbstractSingleFrame
extends CustomFrame
implements Frame {
    private static final long serialVersionUID = 1L;
    public static final int NAVIGATION_TREE_WIDTH = GuiUtils.getComponentWidthForResolution(1280, 280);
    public static final int NAVIGATION_TREE_HEIGHT = GuiUtils.getComponentWidthForResolution(1280, 280);
    public static final int NAVIGATION_TABLE_WIDTH = GuiUtils.getComponentWidthForResolution(1280, 280);
    public static final int NAVIGATION_TABLE_HEIGHT = GuiUtils.getComponentWidthForResolution(1280, 280);
    public static final int CONTEXT_PANEL_WIDTH = GuiUtils.getComponentWidthForResolution(1280, 295);
    public static final int AUDIO_OBJECT_PROPERTIES_PANEL_HEIGHT = 100;
    public static final int PLAY_LIST_PANEL_WIDTH = GuiUtils.getComponentWidthForResolution(1280, 490);
    public static final int MARGIN = 100;
    private FrameState frameState;
    private FrameState oldFrameState;
    private NavigationTreePanel navigationTreePanel;
    private NavigationTablePanel navigationTablePanel;
    private JLabel leftStatusBar;
    private JLabel centerStatusBar;
    private JLabel rightStatusBar;
    private JLabel statusBarDeviceLabel;
    private JLabel statusBarNewPodcastEntriesLabel;
    private JLabel statusBarNewVersionLabel;
    private UpdateDialog updateDialog;
    private JProgressBar progressBar;
    private ApplicationMenuBar appMenuBar;
    private PlayListPanel playListPanel;
    private AudioObjectPropertiesPanel propertiesPanel;
    private ContextPanel contextPanel;
    private PlayerControlsPanel playerControls;
    private JXStatusBar statusBar;
    private ToolBar toolBar;
    private WindowAdapter fullFrameStateListener;
    private Timer statusBarNewVersionInfoTimer = new Timer(1000, new ActionListener(){
        private boolean b;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.b) {
                AbstractSingleFrame.this.getStatusBarNewVersionLabel().setIcon(Images.getImage("checkForUpdates.png"));
            } else {
                AbstractSingleFrame.this.getStatusBarNewVersionLabel().setIcon(Images.getImage("checkForUpdatesBW.png"));
            }
            this.b = !this.b;
        }
    });
    private Logger logger;

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    @Override
    public void create(FrameState frameState) {
        this.frameState = frameState;
        this.oldFrameState = new FrameState(frameState);
        this.setWindowSize();
        Point point = null;
        if (ApplicationState.getInstance().getWindowXPosition() >= 0 && ApplicationState.getInstance().getWindowYPosition() >= 0) {
            point = new Point(ApplicationState.getInstance().getWindowXPosition(), ApplicationState.getInstance().getWindowYPosition());
        }
        if (point != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(null);
        }
        if (SystemProperties.OS == SystemProperties.OperatingSystem.MACOSX) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("dispose", null));
                OSXAdapter.setAboutHandler(this, this.getClass().getDeclaredMethod("about", null));
            }
            catch (Exception exception) {
                this.getLogger().error("STAND FRAME ", exception);
            }
        }
        this.addWindowStateListener(this.getWindowStateListener());
        this.addWindowFocusListener(this.getWindowStateListener());
        this.setContentPane(this.getContentPanel());
        GuiUtils.applyComponentOrientation(this);
        this.setupSplitPaneDividerPosition(frameState);
    }

    protected abstract void setupSplitPaneDividerPosition(FrameState var1);

    private WindowAdapter getWindowStateListener() {
        if (this.fullFrameStateListener == null) {
            this.fullFrameStateListener = new WindowAdapter(){

                @Override
                public void windowStateChanged(WindowEvent windowEvent) {
                    if (windowEvent.getNewState() == 1) {
                        if (ApplicationState.getInstance().isShowSystemTray()) {
                            AbstractSingleFrame.this.setVisible(false);
                        }
                        AbstractSingleFrame.this.getLogger().debug("DESKTOP     ", "Window Iconified");
                    } else if (windowEvent.getNewState() != 1) {
                        AbstractSingleFrame.this.getLogger().debug("DESKTOP     ", "Window Deiconified");
                        ControllerProxy.getInstance().getPlayListController().scrollPlayList(false);
                    }
                }
            };
        }
        return this.fullFrameStateListener;
    }

    @Override
    public void dispose() {
        GuiHandler.getInstance().finish();
        super.dispose();
    }

    public void about() {
        GuiHandler.getInstance().showAboutDialog();
    }

    @Override
    public ApplicationMenuBar getAppMenuBar() {
        if (this.appMenuBar == null) {
            this.appMenuBar = new ApplicationMenuBar();
        }
        return this.appMenuBar;
    }

    @Override
    public ContextPanel getContextPanel() {
        if (this.contextPanel == null) {
            this.contextPanel = new ContextPanel();
            this.contextPanel.setPreferredSize(new Dimension(CONTEXT_PANEL_WIDTH, 1));
            if (!ApplicationState.getInstance().isUseContext()) {
                this.contextPanel.setVisible(false);
            }
        }
        return this.contextPanel;
    }

    private JLabel getCenterStatusBar() {
        if (this.centerStatusBar == null) {
            this.centerStatusBar = new JLabel(" ");
        }
        return this.centerStatusBar;
    }

    protected abstract Container getContentPanel();

    @Override
    public JFrame getFrame() {
        return this;
    }

    private JLabel getLeftStatusBar() {
        if (this.leftStatusBar == null) {
            this.leftStatusBar = new JLabel(I18nUtils.getString("STOPPED"));
        }
        return this.leftStatusBar;
    }

    @Override
    public NavigationTreePanel getNavigationTreePanel() {
        if (this.navigationTreePanel == null) {
            this.navigationTreePanel = new NavigationTreePanel();
            this.navigationTreePanel.setPreferredSize(new Dimension(NAVIGATION_TREE_WIDTH, NAVIGATION_TREE_HEIGHT));
        }
        return this.navigationTreePanel;
    }

    @Override
    public NavigationTablePanel getNavigationTablePanel() {
        if (this.navigationTablePanel == null) {
            this.navigationTablePanel = new NavigationTablePanel();
            this.navigationTablePanel.setPreferredSize(new Dimension(NAVIGATION_TABLE_WIDTH, NAVIGATION_TABLE_HEIGHT));
        }
        return this.navigationTablePanel;
    }

    @Override
    public PlayerControlsPanel getPlayerControls() {
        if (this.playerControls == null) {
            this.playerControls = new PlayerControlsPanel();
        }
        return this.playerControls;
    }

    @Override
    public PlayListPanel getPlayListPanel() {
        if (this.playListPanel == null) {
            this.playListPanel = new PlayListPanel();
            this.playListPanel.setMinimumSize(new Dimension(PLAY_LIST_PANEL_WIDTH, 1));
            this.playListPanel.setPreferredSize(new Dimension(PLAY_LIST_PANEL_WIDTH, 1));
        }
        return this.playListPanel;
    }

    @Override
    public PlayListTable getPlayListTable() {
        return this.getPlayListPanel().getPlayListTable();
    }

    @Override
    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.progressBar;
    }

    @Override
    public AudioObjectPropertiesPanel getPropertiesPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new AudioObjectPropertiesPanel();
            this.propertiesPanel.setPreferredSize(new Dimension(1, 100));
            if (!ApplicationState.getInstance().isShowAudioObjectProperties()) {
                this.propertiesPanel.setVisible(false);
            }
        }
        return this.propertiesPanel;
    }

    private JLabel getRightStatusBar() {
        if (this.rightStatusBar == null) {
            this.rightStatusBar = new JLabel(" ");
        }
        return this.rightStatusBar;
    }

    protected final JXStatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new JXStatusBar();
            JXStatusBar.Constraint constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.statusBar.add((Component)this.getLeftStatusBar(), (Object)constraint);
            constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.statusBar.add((Component)this.getCenterStatusBar(), (Object)constraint);
            constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.statusBar.add((Component)this.getRightStatusBar(), (Object)constraint);
            constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusBar.add((Component)this.getProgressBar(), (Object)constraint);
        }
        return this.statusBar;
    }

    private JLabel getStatusBarDeviceLabel() {
        if (this.statusBarDeviceLabel == null) {
            this.statusBarDeviceLabel = new JLabel(Images.getImage("device.png"));
        }
        return this.statusBarDeviceLabel;
    }

    private JLabel getStatusBarNewPodcastEntriesLabel() {
        if (this.statusBarNewPodcastEntriesLabel == null) {
            this.statusBarNewPodcastEntriesLabel = new JLabel(Images.getImage("rss_little.png"));
            this.statusBarNewPodcastEntriesLabel.setToolTipText(I18nUtils.getString("NEW_PODCAST_ENTRIES"));
            this.statusBarNewPodcastEntriesLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractSingleFrame.this.showNewPodcastFeedEntriesInfo(false);
                    ControllerProxy.getInstance().getNavigationController().setNavigationView(PodcastNavigationView.class.getName());
                }
            });
        }
        return this.statusBarNewPodcastEntriesLabel;
    }

    JLabel getStatusBarNewVersionLabel() {
        if (this.statusBarNewVersionLabel == null) {
            this.statusBarNewVersionLabel = new JLabel(Images.getImage("checkForUpdates.png"));
            this.statusBarNewVersionLabel.setToolTipText(I18nUtils.getString("NEW_VERSION_AVAILABLE"));
            this.statusBarNewVersionLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractSingleFrame.this.updateDialog.setVisible(true);
                    AbstractSingleFrame.this.updateDialog.toFront();
                    AbstractSingleFrame.this.showNewVersionInfo(false, null);
                }
            });
        }
        return this.statusBarNewVersionLabel;
    }

    @Override
    public ToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new ToolBar();
        }
        return this.toolBar;
    }

    @Override
    public void setCenterStatusBarText(String string, String string2) {
        this.getCenterStatusBar().setText(string);
        this.getCenterStatusBar().setToolTipText(string2);
    }

    @Override
    public void setLeftStatusBarText(String string, String string2) {
        this.getLeftStatusBar().setText(string);
        this.getLeftStatusBar().setToolTipText(string2);
    }

    @Override
    public void setRightStatusBarText(String string, String string2) {
        this.getRightStatusBar().setText(string);
        this.getRightStatusBar().setToolTipText(string2);
    }

    @Override
    public void setStatusBarDeviceLabelText(String string) {
        this.getStatusBarDeviceLabel().setText(string);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && SystemProperties.OS == SystemProperties.OperatingSystem.LINUX && ApplicationState.getInstance().isMaximized()) {
            this.setWindowSizeMaximized();
        }
        Timer timer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Toolkit.getDefaultToolkit().getScreenSize().width + 15 < AbstractSingleFrame.this.getSize().width) {
                    AbstractSingleFrame.this.setWindowSize();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void setWindowSize() {
        this.setMinimumSize(new Dimension(655, 410));
        if (ApplicationState.getInstance().isMaximized()) {
            this.setWindowSizeMaximized();
        } else {
            Dimension dimension = null;
            if (ApplicationState.getInstance().getWindowWidth() != 0 && ApplicationState.getInstance().getWindowHeight() != 0) {
                dimension = new Dimension(ApplicationState.getInstance().getWindowWidth(), ApplicationState.getInstance().getWindowHeight());
            }
            if (dimension != null) {
                this.setSize(dimension);
            } else {
                this.setSize((GuiUtils.getDeviceWidth() > 2000 ? GuiUtils.getDeviceWidth() / 2 : GuiUtils.getDeviceWidth()) - 100, GuiUtils.getDeviceHeight() - 100);
            }
        }
    }

    private void setWindowSizeMaximized() {
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setSize(dimension.width - 100, dimension.height - 100);
        this.setExtendedState(6);
    }

    @Override
    public void showSongProperties(boolean bl) {
        this.getPropertiesPanel().setVisible(bl);
    }

    @Override
    public void showStatusBar(boolean bl) {
        this.getStatusBar().setVisible(bl);
    }

    @Override
    public void showToolBar(boolean bl) {
        this.getToolBar().setVisible(bl);
    }

    @Override
    public void showDeviceInfo(boolean bl) {
        if (bl) {
            JXStatusBar.Constraint constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusBar.add((Component)this.getStatusBarDeviceLabel(), (Object)constraint);
        } else {
            this.statusBar.remove((Component)this.getStatusBarDeviceLabel());
        }
        this.getStatusBarDeviceLabel().setVisible(bl);
        this.statusBar.validate();
        this.statusBar.repaint();
    }

    @Override
    public void showNewPodcastFeedEntriesInfo(boolean bl) {
        if (bl) {
            if (Arrays.asList(this.statusBar.getComponents()).contains(this.getStatusBarNewPodcastEntriesLabel())) {
                return;
            }
            JXStatusBar.Constraint constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusBar.add((Component)this.getStatusBarNewPodcastEntriesLabel(), (Object)constraint);
        } else {
            this.statusBar.remove((Component)this.getStatusBarNewPodcastEntriesLabel());
        }
        this.getStatusBarNewPodcastEntriesLabel().setVisible(bl);
        this.statusBar.validate();
        this.statusBar.repaint();
    }

    @Override
    public void showNewVersionInfo(boolean bl, ApplicationVersion applicationVersion) {
        if (bl && applicationVersion == null) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            if (Arrays.asList(this.statusBar.getComponents()).contains(this.getStatusBarNewVersionLabel())) {
                return;
            }
            JXStatusBar.Constraint constraint = new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusBar.add((Component)this.getStatusBarNewVersionLabel(), (Object)constraint);
            this.statusBarNewVersionInfoTimer.start();
            this.updateDialog = new UpdateDialog(applicationVersion, this.getFrame());
        } else {
            this.statusBarNewVersionInfoTimer.stop();
            this.statusBar.remove((Component)this.getStatusBarNewVersionLabel());
            this.updateDialog = null;
        }
        this.getStatusBarNewVersionLabel().setVisible(bl);
        this.statusBar.validate();
        this.statusBar.repaint();
    }

    @Override
    public FrameState getFrameState() {
        return this.frameState;
    }

    protected final void applyVisibility(boolean bl, String string, Component component, JSplitPane jSplitPane) {
        if (!bl) {
            this.oldFrameState.putSplitPaneDividerPos(string, this.getFrameState().getSplitPaneDividerPos(string));
        }
        boolean bl2 = component.isVisible();
        component.setVisible(bl);
        if (bl && !bl2) {
            AbstractSingleFrame.applySplitPaneDividerPosition(jSplitPane, this.oldFrameState.getSplitPaneDividerPos(string), 0.0);
        }
    }

    protected static void applySplitPaneDividerPosition(JSplitPane jSplitPane, int n, double d) {
        if (n != 0) {
            jSplitPane.setDividerLocation(n);
        } else {
            jSplitPane.setDividerLocation(d);
        }
    }
}

