/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.lookandfeel;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.lookandfeel.AbstractLookAndFeel;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelBean;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelChangeListener;
import net.sourceforge.atunes.gui.lookandfeel.nimbus.NimbusLookAndFeel;
import net.sourceforge.atunes.gui.lookandfeel.substance.SubstanceLookAndFeel;
import net.sourceforge.atunes.gui.lookandfeel.system.SystemLookAndFeel;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.plugins.PluginsHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.Plugin;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginListener;

public final class LookAndFeelSelector
implements PluginListener {
    private static LookAndFeelSelector instance;
    private Logger logger;
    private AbstractLookAndFeel currentLookAndFeel;
    private Map<String, AbstractLookAndFeel> lookAndFeels = new HashMap<String, AbstractLookAndFeel>();
    private static AbstractLookAndFeel defaultLookAndFeel;
    private static List<LookAndFeelChangeListener> changeListeners;

    private LookAndFeelSelector() {
        this.lookAndFeels.put(defaultLookAndFeel.getName(), defaultLookAndFeel);
        SystemLookAndFeel systemLookAndFeel = new SystemLookAndFeel();
        this.lookAndFeels.put(systemLookAndFeel.getName(), systemLookAndFeel);
        if (SystemProperties.IS_JAVA_6_UPDATE_10_OR_LATER) {
            NimbusLookAndFeel nimbusLookAndFeel = new NimbusLookAndFeel();
            this.lookAndFeels.put(nimbusLookAndFeel.getName(), nimbusLookAndFeel);
        }
    }

    public static LookAndFeelSelector getInstance() {
        if (instance == null) {
            instance = new LookAndFeelSelector();
        }
        return instance;
    }

    public void pluginActivated(PluginInfo pluginInfo) {
        try {
            AbstractLookAndFeel abstractLookAndFeel = (AbstractLookAndFeel)PluginsHandler.getInstance().getNewInstance(pluginInfo);
            this.lookAndFeels.put(abstractLookAndFeel.getName(), abstractLookAndFeel);
        }
        catch (PluginSystemException pluginSystemException) {
            this.getLogger().error("PLUGINS     ", (Object)pluginSystemException);
        }
    }

    public void pluginDeactivated(PluginInfo pluginInfo, Collection<Plugin> collection) {
        for (Plugin plugin : collection) {
            this.lookAndFeels.remove(((AbstractLookAndFeel)plugin).getName());
        }
    }

    public void setLookAndFeel(LookAndFeelBean lookAndFeelBean) {
        if (Kernel.isIgnoreLookAndFeel()) {
            return;
        }
        if (lookAndFeelBean == null || lookAndFeelBean.getName() == null) {
            lookAndFeelBean = new LookAndFeelBean();
            lookAndFeelBean.setName(defaultLookAndFeel.getName());
            lookAndFeelBean.setSkin(defaultLookAndFeel.getDefaultSkin());
            if (ApplicationState.getInstance().getLookAndFeel() == null) {
                ApplicationState.getInstance().setLookAndFeel(lookAndFeelBean);
            }
        }
        this.currentLookAndFeel = this.lookAndFeels.get(lookAndFeelBean.getName());
        if (this.currentLookAndFeel == null) {
            this.currentLookAndFeel = defaultLookAndFeel;
        }
        this.currentLookAndFeel.initializeLookAndFeel();
        this.currentLookAndFeel.setLookAndFeel(lookAndFeelBean.getSkin());
    }

    public List<String> getAvailableLookAndFeels() {
        return new ArrayList<String>(this.lookAndFeels.keySet());
    }

    public List<String> getAvailableSkins(String string) {
        AbstractLookAndFeel abstractLookAndFeel = this.lookAndFeels.get(string);
        if (abstractLookAndFeel != null) {
            return abstractLookAndFeel.getSkins() != null ? abstractLookAndFeel.getSkins() : new ArrayList<String>();
        }
        return new ArrayList<String>();
    }

    public String getCurrentLookAndFeelName() {
        return this.currentLookAndFeel.getName();
    }

    public void applySkin(String string) {
        LookAndFeelBean lookAndFeelBean = new LookAndFeelBean();
        lookAndFeelBean.setName(this.currentLookAndFeel.getName());
        lookAndFeelBean.setSkin(string);
        this.setLookAndFeel(lookAndFeelBean);
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
        for (LookAndFeelChangeListener lookAndFeelChangeListener : LookAndFeelSelector.getChangeListeners()) {
            lookAndFeelChangeListener.lookAndFeelChanged();
        }
    }

    public AbstractLookAndFeel getCurrentLookAndFeel() {
        return this.currentLookAndFeel;
    }

    public String getDefaultSkin(String string) {
        AbstractLookAndFeel abstractLookAndFeel = this.lookAndFeels.get(string);
        if (abstractLookAndFeel != null) {
            return abstractLookAndFeel.getDefaultSkin();
        }
        return null;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    public static AbstractLookAndFeel getDefaultLookAndFeel() {
        return defaultLookAndFeel;
    }

    protected static List<LookAndFeelChangeListener> getChangeListeners() {
        if (changeListeners == null) {
            changeListeners = new ArrayList<LookAndFeelChangeListener>();
        }
        return changeListeners;
    }

    public void addLookAndFeelChangeListener(LookAndFeelChangeListener lookAndFeelChangeListener) {
        LookAndFeelSelector.getChangeListeners().add(lookAndFeelChangeListener);
    }

    public void removeLookAndFeelChangeListener(LookAndFeelChangeListener lookAndFeelChangeListener) {
        LookAndFeelSelector.getChangeListeners().remove(lookAndFeelChangeListener);
    }

    static {
        defaultLookAndFeel = new SubstanceLookAndFeel();
    }
}

