/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelChangeListener;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.EditionPopUpMenu;

public final class CustomTextPane
extends JTextPane
implements LookAndFeelChangeListener {
    private static final long serialVersionUID = -3601855261867415475L;
    private int alignment;

    public CustomTextPane(int n) {
        this.alignment = n;
        this.updateStyle(false);
        new EditionPopUpMenu(this);
        LookAndFeelSelector.getInstance().addLookAndFeelChangeListener(this);
    }

    @Override
    public void lookAndFeelChanged() {
        this.updateStyle(true);
    }

    private void updateStyle(boolean bl) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, this.alignment);
        StyleConstants.setFontFamily(simpleAttributeSet, UIManager.getFont("Label.font").getFamily());
        StyleConstants.setFontSize(simpleAttributeSet, UIManager.getFont("Label.font").getSize());
        StyleConstants.setForeground(simpleAttributeSet, UIManager.getColor("Label.foreground"));
        this.getStyledDocument().setParagraphAttributes(0, 0, simpleAttributeSet, true);
        if (bl) {
            this.setText(this.getText());
        }
    }
}

