/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.gui.views.controls.UrlLabel;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class AboutDialog
extends AbstractCustomModalDialog {
    static final String[] VERSION = new String[]{"Version", Constants.VERSION.toString()};
    static final String[] JAVA_VERSION = new String[]{"Java Runtime Enviroment", System.getProperty("java.version")};
    static final String[] OS_NAME = new String[]{"OS", StringUtils.getString(System.getProperty("os.name"), " (", System.getProperty("os.arch"), Character.valueOf(')'))};
    private static final long serialVersionUID = 8666235475424750562L;
    private AboutDialogTableModel tableModel = new AboutDialogTableModel();
    private String licenseText = this.getLicenseText();
    private Timer timer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog.this.tableModel.refreshData();
            AboutDialog.this.tableModel.fireTableDataChanged();
        }
    });

    public AboutDialog(JFrame jFrame) {
        super((Window)jFrame, 600, 550, true);
        this.setContent(this.getContent());
        this.setResizable(false);
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        UrlLabel urlLabel = new UrlLabel("aTunes " + Constants.VERSION.toString(), "http://www.atunes.org");
        urlLabel.setFont(Fonts.getAboutBigFont());
        urlLabel.setFocusPainted(false);
        JLabel jLabel = new JLabel("GPL Audio Player");
        JLabel jLabel2 = new JLabel(Images.getImage("logo90x90.png"));
        CustomTextArea customTextArea = new CustomTextArea(this.licenseText);
        customTextArea.setEditable(false);
        customTextArea.setLineWrap(true);
        customTextArea.setWrapStyleWord(true);
        customTextArea.setOpaque(false);
        customTextArea.setBorder(BorderFactory.createEmptyBorder());
        UrlLabel urlLabel2 = new UrlLabel(I18nUtils.getString("CONTRIBUTORS"), "http://www.atunes.org/?page_id=7");
        urlLabel2.setFont(Fonts.getAppVersionLittleFont());
        JTable jTable = new JTable(this.tableModel);
        jTable.setShowGrid(false);
        jTable.setDefaultRenderer(Object.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        CustomButton customButton = new CustomButton(null, I18nUtils.getString("CLOSE"));
        customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.setVisible(false);
            }
        });
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(I18nUtils.getString("LICENSE"), customTextArea);
        jTabbedPane.addTab(I18nUtils.getString("PROPERTIES"), jScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        gridBagConstraints.anchor = GuiUtils.getComponentOrientation().isLeftToRight() ? 17 : 13;
        jPanel.add((Component)((Object)urlLabel), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)((Object)urlLabel2), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.anchor = GuiUtils.getComponentOrientation().isLeftToRight() ? 13 : 17;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        jPanel.add((Component)jTabbedPane, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 20, 10, 20);
        jPanel.add((Component)customButton, gridBagConstraints);
        return jPanel;
    }

    private String getLicenseText() {
        return StringUtils.getString("Copyright (C) 2006-2010  The aTunes Team\n\n", "This program is free software; you can redistribute it and/or ", "modify it under the terms of the GNU General Public License ", "as published by the Free Software Foundation; either version 2 ", "of the License, or (at your option) any later version.\n\n", "This program is distributed in the hope that it will be useful, ", "but WITHOUT ANY WARRANTY; without even the implied warranty of ", "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the ", "GNU General Public License for more details.\n\n", "You should have received a copy of the GNU General Public License ", "along with this program; if not, write to the\n\nFree Software ", "Foundation, Inc.\n51 Franklin Street, Fifth Floor\nBoston, MA\n02110-1301, USA");
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
        super.setVisible(bl);
    }

    private static class AboutDialogTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1786557125033788184L;
        private List<String[]> valuesToShow;

        AboutDialogTableModel() {
            this.refreshData();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? "Property" : "Value";
        }

        private List<String[]> getData() {
            MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            MemoryUsage memoryUsage2 = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            arrayList.add(VERSION);
            arrayList.add(JAVA_VERSION);
            arrayList.add(OS_NAME);
            arrayList.add(new String[]{"Used Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage.getUsed())});
            arrayList.add(new String[]{"Max Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage.getMax())});
            arrayList.add(new String[]{"Initial Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage.getInit())});
            arrayList.add(new String[]{"Committed Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage.getCommitted())});
            arrayList.add(new String[]{"Used Non Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage2.getUsed())});
            arrayList.add(new String[]{"Max Non Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage2.getMax())});
            arrayList.add(new String[]{"Initial Non Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage2.getInit())});
            arrayList.add(new String[]{"Committed Non Heap Space", StringUtils.fromByteToMegaOrGiga(memoryUsage2.getCommitted())});
            arrayList.add(new String[]{"Uptime", StringUtils.fromSecondsToHoursAndDays(runtimeMXBean.getUptime() / 1000L)});
            arrayList.add(new String[]{"Total Loaded Classes Count", String.valueOf(classLoadingMXBean.getTotalLoadedClassCount())});
            arrayList.add(new String[]{"Loaded Classes Count", String.valueOf(classLoadingMXBean.getLoadedClassCount())});
            arrayList.add(new String[]{"Unloaded Classes Count", String.valueOf(classLoadingMXBean.getUnloadedClassCount())});
            arrayList.add(new String[]{"Thread Count", String.valueOf(threadMXBean.getThreadCount())});
            long l = 0L;
            for (GarbageCollectorMXBean garbageCollectorMXBean : list) {
                l += Math.max(0L, garbageCollectorMXBean.getCollectionCount());
            }
            arrayList.add(new String[]{"Garbage Collection Count", String.valueOf(l)});
            return arrayList;
        }

        @Override
        public int getRowCount() {
            return this.valuesToShow.size();
        }

        @Override
        public String getValueAt(int n, int n2) {
            return this.valuesToShow.get(n)[n2];
        }

        public void refreshData() {
            this.valuesToShow = this.getData();
        }
    }
}

