/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class ImageDialog
extends CustomFrame {
    private static final long serialVersionUID = -5163960681035103913L;
    private JLabel imageLabel;
    private JScrollPane scrollPane;

    public ImageDialog(JFrame jFrame, AudioObject audioObject) {
        super(null, 900, 700, jFrame);
        ImageIcon[] imageIconArray;
        ImageIcon[] imageIconArray2;
        if (audioObject instanceof Radio) {
            imageIconArray2 = new ImageIcon[]{Images.getImage("radio_big.png")};
            imageIconArray = new ImageIcon[]{Images.getImage("radio.png")};
        } else if (audioObject instanceof PodcastFeedEntry) {
            imageIconArray2 = new ImageIcon[]{Images.getImage("rss_big.png")};
            imageIconArray = new ImageIcon[]{Images.getImage("rss.png")};
        } else {
            imageIconArray2 = AudioFilePictureUtils.getPicturesForFile((AudioFile)audioObject, -1, -1);
            imageIconArray = AudioFilePictureUtils.getPicturesForFile((AudioFile)audioObject, Constants.IMAGE_SIZE.getSize(), Constants.IMAGE_SIZE.getSize());
        }
        if (imageIconArray2.length > 1) {
            this.setTitle(StringUtils.getString("aTunes", " - ", I18nUtils.getString("PICTURES_OF_FILE"), " ", audioObject.getTitle()));
        } else {
            this.setTitle(StringUtils.getString("aTunes", " - ", I18nUtils.getString("PICTURE_OF_FILE"), " ", audioObject.getTitle()));
        }
        this.setResizable(imageIconArray2.length > 1);
        this.setDefaultCloseOperation(2);
        this.addContent(imageIconArray2, imageIconArray);
        GuiUtils.applyComponentOrientation(this);
        this.enableDisposeActionWithEscapeKey();
        this.setVisible(true);
    }

    private void addContent(ImageIcon[] imageIconArray, final ImageIcon[] imageIconArray2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.imageLabel = new JLabel(this.scaleImageIfNecessaryToFitWindow(imageIconArray[0], imageIconArray2[0].getIconHeight()));
        this.scrollPane = new JScrollPane(this.imageLabel);
        jPanel.add((Component)this.scrollPane, "Center");
        if (imageIconArray.length > 1) {
            FlowLayout flowLayout = new FlowLayout(1, 10, 25);
            JPanel jPanel2 = new JPanel(flowLayout);
            for (int i = 0; i < imageIconArray2.length; ++i) {
                final ImageIcon imageIcon = imageIconArray[i];
                if (imageIcon == null) continue;
                JButton jButton = new JButton(imageIconArray2[i]);
                jButton.setPreferredSize(new Dimension(imageIconArray2[i].getIconWidth(), imageIconArray2[i].getIconHeight()));
                jButton.setSize(jButton.getSize());
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ImageDialog.this.imageLabel.setIcon(ImageDialog.this.scaleImageIfNecessaryToFitWindow(imageIcon, imageIconArray2[0].getIconHeight()));
                    }
                });
                jPanel2.add(jButton);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jPanel.add((Component)jScrollPane, "South");
        }
        this.setContentPane(jPanel);
    }

    ImageIcon scaleImageIfNecessaryToFitWindow(ImageIcon imageIcon, int n) {
        int n2 = this.getWidth() - 50;
        int n3 = this.getHeight() - n - 150;
        if (imageIcon.getIconWidth() > n2 || imageIcon.getIconHeight() > n3) {
            return ImageUtils.scaleImageBicubic(imageIcon.getImage(), n2, n3);
        }
        return imageIcon;
    }
}

