/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class LanguageSelectorDialog
extends JDialog {
    private static final long serialVersionUID = 8846024391499257859L;
    private static JFrame frame = LanguageSelectorDialog.getFrame();
    private String selection;
    private JList list;

    public LanguageSelectorDialog(String[] stringArray) {
        super(frame, "Select Language", true);
        this.setSize(250, 350);
        this.setLocationRelativeTo(null);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.list = new JList<String>(stringArray);
        this.list.setSelectedValue("English", false);
        this.list.setFont(this.list.getFont().deriveFont(0));
        this.list.setSelectionMode(0);
        this.list.setBorder(BorderFactory.createLineBorder(GuiUtils.getBorderColor()));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.list.setCellRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getListCellRenderer(new LanguageSelectorListCellRendererCode()));
        CustomButton customButton = new CustomButton(null, "OK");
        customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageSelectorDialog.this.selection = (String)LanguageSelectorDialog.this.list.getSelectedValue();
                LanguageSelectorDialog.this.setVisible(false);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)customButton, gridBagConstraints);
        this.add(jPanel);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private static JFrame getFrame() {
        JFrame jFrame = new JFrame();
        jFrame.setIconImage(Images.getImage("language.png").getImage());
        return jFrame;
    }

    public static void main(String[] stringArray) {
        new LanguageSelectorDialog(new String[]{"Lang1", "Lang2", "Lang3", "Lang4", "Lang5", "Lang6", "Lang7", "Lang8", "Lang9", "Lang10", "Lang11", "Lang12"});
    }

    public String getSelection() {
        return this.selection;
    }

    private static class LanguageSelectorListCellRendererCode
    extends AbstractListCellRendererCode {
        private LanguageSelectorListCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component2 = component;
            String string = StringUtils.getString(((String)object).toLowerCase(), ".png");
            ((JLabel)component2).setIcon(new ImageIcon(LanguageSelectorDialog.class.getResource(StringUtils.getString("/", "translations", "/", string))));
            return component2;
        }
    }
}

