/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.repository.tags.IncompleteTagsChecker;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.TagAttribute;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class NavigatorPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -4315748284461119970L;
    private JCheckBox showFavorites = new JCheckBox(I18nUtils.getString("SHOW_FAVORITES"));
    private JCheckBox showExtendedToolTip = new JCheckBox(I18nUtils.getString("SHOW_EXTENDED_TOOLTIP"));
    private JComboBox extendedToolTipDelay;
    private JCheckBox useSmartTagViewSorting;
    private JCheckBox useArtistNamesSorting;
    private JCheckBox showNavigatorTabsAtLeft;
    private JCheckBox showNavigatorTabsText;
    private JCheckBox highlightElementsWithIncompleteBasicTags;
    private JTable highlighTagAttributesTable;
    private JScrollPane highlightTagAttributesScrollPane;
    private TagAttributesTableModel tagAttributesTableModel;

    public NavigatorPanel() {
        super(I18nUtils.getString("NAVIGATOR"));
        final JLabel jLabel = new JLabel(I18nUtils.getString("EXTENDED_TOOLTIP_DELAY"));
        this.extendedToolTipDelay = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5});
        this.showExtendedToolTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setEnabled(NavigatorPanel.this.showExtendedToolTip.isSelected());
                NavigatorPanel.this.extendedToolTipDelay.setEnabled(NavigatorPanel.this.showExtendedToolTip.isSelected());
            }
        });
        this.useSmartTagViewSorting = new JCheckBox(I18nUtils.getString("USE_SMART_TAG_VIEW_SORTING"));
        this.useArtistNamesSorting = new JCheckBox(I18nUtils.getString("USE_PERSON_NAMES_ARTIST_TAG_VIEW_SORTING"));
        this.showNavigatorTabsAtLeft = new JCheckBox(I18nUtils.getString("SHOW_NAVIGATION_TABS_AT_LEFT"));
        this.showNavigatorTabsText = new JCheckBox(I18nUtils.getString("SHOW_NAVIGATION_TABS_TEXT"));
        this.highlightElementsWithIncompleteBasicTags = new JCheckBox(I18nUtils.getString("HIGHLIGHT_INCOMPLETE_TAG_ELEMENTS"));
        this.highlightElementsWithIncompleteBasicTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavigatorPanel.this.highlightTagAttributesScrollPane.setEnabled(NavigatorPanel.this.highlightElementsWithIncompleteBasicTags.isSelected());
                        NavigatorPanel.this.highlighTagAttributesTable.setEnabled(NavigatorPanel.this.highlightElementsWithIncompleteBasicTags.isSelected());
                    }
                });
            }
        });
        this.tagAttributesTableModel = new TagAttributesTableModel();
        this.tagAttributesTableModel.setTagAttributes(IncompleteTagsChecker.getAllTagAttributes());
        this.highlighTagAttributesTable = new JTable(this.tagAttributesTableModel);
        this.highlighTagAttributesTable.setShowGrid(false);
        this.highlighTagAttributesTable.setTableHeader(null);
        this.highlighTagAttributesTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this.highlighTagAttributesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.highlighTagAttributesTable.getSelectionModel().setSelectionMode(0);
        this.highlighTagAttributesTable.setDefaultRenderer(String.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        this.highlightTagAttributesScrollPane = new JScrollPane(this.highlighTagAttributesTable);
        this.highlightTagAttributesScrollPane.setMinimumSize(new Dimension(300, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.showFavorites, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.showExtendedToolTip, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.extendedToolTipDelay, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.useSmartTagViewSorting, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.useArtistNamesSorting, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.showNavigatorTabsAtLeft, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.showNavigatorTabsText, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.add((Component)this.highlightElementsWithIncompleteBasicTags, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = GuiUtils.getComponentOrientation().isLeftToRight() ? 18 : 12;
        gridBagConstraints.insets = new Insets(10, 20, 10, 10);
        this.add((Component)this.highlightTagAttributesScrollPane, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setShowFavoritesInNavigator(this.showFavorites.isSelected());
        applicationState.setShowExtendedTooltip(this.showExtendedToolTip.isSelected());
        applicationState.setExtendedTooltipDelay((Integer)this.extendedToolTipDelay.getSelectedItem());
        applicationState.setUseSmartTagViewSorting(this.useSmartTagViewSorting.isSelected());
        applicationState.setShowNavigatorTabsAtLeft(this.showNavigatorTabsAtLeft.isSelected());
        applicationState.setShowNavigatorTabsText(this.showNavigatorTabsText.isSelected());
        applicationState.setHighlightIncompleteTagElements(this.highlightElementsWithIncompleteBasicTags.isSelected());
        applicationState.setHighlightIncompleteTagFoldersAttributes(this.tagAttributesTableModel.getSelectedTagAttributes());
        applicationState.setUsePersonNamesArtistTagViewSorting(this.useArtistNamesSorting.isSelected());
        return false;
    }

    public void setAlbumToolTipDelay(int n) {
        this.extendedToolTipDelay.setSelectedItem(n);
    }

    public void setShowAlbumToolTip(boolean bl) {
        this.showExtendedToolTip.setSelected(bl);
    }

    private void setShowFavorites(boolean bl) {
        this.showFavorites.setSelected(bl);
    }

    private void setUseSmartTagViewSorting(boolean bl) {
        this.useSmartTagViewSorting.setSelected(bl);
    }

    private void setUsePersonNamesArtistTagViewSorting(boolean bl) {
        this.useArtistNamesSorting.setSelected(bl);
    }

    private void setShowNavigatorTabsAtLeft(boolean bl) {
        this.showNavigatorTabsAtLeft.setSelected(bl);
    }

    private void setShowNavigatorTabsText(boolean bl) {
        this.showNavigatorTabsText.setSelected(bl);
    }

    private void setHighlightFoldersWithIncompleteBasicTags(boolean bl) {
        this.highlightElementsWithIncompleteBasicTags.setSelected(bl);
        this.highlightTagAttributesScrollPane.setEnabled(bl);
        this.highlighTagAttributesTable.setEnabled(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setShowFavorites(applicationState.isShowFavoritesInNavigator());
        this.setShowAlbumToolTip(applicationState.isShowExtendedTooltip());
        this.setAlbumToolTipDelay(applicationState.getExtendedTooltipDelay());
        this.setUseSmartTagViewSorting(applicationState.isUseSmartTagViewSorting());
        this.setShowNavigatorTabsAtLeft(applicationState.isShowNavigatorTabsAtLeft());
        this.setShowNavigatorTabsText(applicationState.isShowNavigatorTabsText());
        this.setHighlightFoldersWithIncompleteBasicTags(applicationState.isHighlightIncompleteTagElements());
        this.setUsePersonNamesArtistTagViewSorting(applicationState.isUsePersonNamesArtistTagViewSorting());
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("navigate.png");
    }

    private static class TagAttributesTableModel
    implements TableModel {
        private static final long serialVersionUID = 5251001708812824836L;
        private Map<TagAttribute, Boolean> tagAttributes;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        TagAttributesTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return "";
        }

        @Override
        public int getRowCount() {
            if (this.tagAttributes != null) {
                return this.tagAttributes.size();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.tagAttributes.get((Object)TagAttribute.values()[n]);
            }
            return I18nUtils.getString(TagAttribute.values()[n].name());
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        public void setTagAttributes(Map<TagAttribute, Boolean> map) {
            this.tagAttributes = map;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.tagAttributes.put(TagAttribute.values()[n], (Boolean)object);
            }
        }

        public List<TagAttribute> getSelectedTagAttributes() {
            ArrayList<TagAttribute> arrayList = new ArrayList<TagAttribute>();
            for (TagAttribute tagAttribute : this.tagAttributes.keySet()) {
                if (!this.tagAttributes.get((Object)tagAttribute).booleanValue()) continue;
                arrayList.add(tagAttribute);
            }
            return arrayList;
        }
    }
}

