/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class RadioPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 4489293347321979288L;
    private JCheckBox readInfoFromRadioStream = new JCheckBox(I18nUtils.getString("READ_INFO_FROM_RADIO_STREAM"));
    private JCheckBox showAllRadioStations = new JCheckBox(I18nUtils.getString("SHOW_ALL_RADIO_STATIONS"));

    public RadioPanel() {
        super(I18nUtils.getString("RADIO"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.readInfoFromRadioStream, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.showAllRadioStations, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setReadInfoFromRadioStream(this.readInfoFromRadioStream.isSelected());
        applicationState.setShowAllRadioStations(this.showAllRadioStations.isSelected());
        return false;
    }

    private void setReadInfoFromRadioStream(boolean bl) {
        this.readInfoFromRadioStream.setSelected(bl);
    }

    private void setShowAllRadioStations(boolean bl) {
        this.showAllRadioStations.setSelected(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setReadInfoFromRadioStream(applicationState.isReadInfoFromRadioStream());
        this.setShowAllRadioStations(applicationState.isShowAllRadioStations());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("radio_little.png");
    }
}

