/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomTextArea;
import net.sourceforge.atunes.gui.views.dialogs.properties.PropertiesDialog;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

final class PodcastFeedEntryPropertiesDialog
extends PropertiesDialog {
    private static final long serialVersionUID = -2472573171771586037L;
    private JLabel pictureLabel;
    private JLabel titleLabel;
    private JLabel artistLabel;
    private JLabel urlLabel;
    private JLabel durationLabel;
    private JLabel dateLabel;
    private JLabel podcastFeedLabel;
    private JLabel downloadedLabel;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private PodcastFeedEntry entry;

    PodcastFeedEntryPropertiesDialog(PodcastFeedEntry podcastFeedEntry, JFrame jFrame) {
        super(PodcastFeedEntryPropertiesDialog.getTitleText(podcastFeedEntry), jFrame);
        this.entry = podcastFeedEntry;
        this.setAudioObject(podcastFeedEntry);
        this.addContent();
        this.setContent();
        GuiUtils.applyComponentOrientation(this);
    }

    private static String getTitleText(PodcastFeedEntry podcastFeedEntry) {
        return StringUtils.getString(I18nUtils.getString("INFO_OF_PODCAST_FEED"), " ", podcastFeedEntry.getTitle());
    }

    private void addContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.pictureLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)this.pictureLabel, gridBagConstraints);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.artistLabel = new JLabel();
        this.artistLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.artistLabel, gridBagConstraints);
        this.urlLabel = new JLabel();
        this.urlLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.urlLabel, gridBagConstraints);
        this.durationLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.durationLabel, gridBagConstraints);
        this.dateLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.dateLabel, gridBagConstraints);
        this.podcastFeedLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.podcastFeedLabel, gridBagConstraints);
        this.downloadedLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)this.downloadedLabel, gridBagConstraints);
        this.descriptionLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        jPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionScrollPane.setMinimumSize(new Dimension(400, 100));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        jPanel.add((Component)this.descriptionScrollPane, gridBagConstraints);
        this.descriptionTextArea = new CustomTextArea();
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.add(jPanel);
    }

    private void fillPicture() {
        ImageIcon imageIcon = Images.getImage("rss.png");
        this.pictureLabel.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.pictureLabel.setIcon(imageIcon);
        this.pictureLabel.setVisible(true);
    }

    private void setContent() {
        this.fillPicture();
        this.titleLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("NAME"), StringUtils.isEmpty(this.entry.getTitle()) ? "-" : this.entry.getTitle()));
        this.artistLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("ARTIST"), StringUtils.isEmpty(this.entry.getArtist()) ? "-" : this.entry.getArtist()));
        this.urlLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("URL"), this.entry.getUrl()));
        if (this.entry.getDuration() > 0) {
            this.durationLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("DURATION"), StringUtils.seconds2String(this.entry.getDuration())));
        } else {
            this.durationLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("DURATION"), "-"));
        }
        if (this.entry.getDate() != null) {
            this.dateLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("DATE"), StringUtils.getString(DateFormat.getDateInstance(1, ApplicationState.getInstance().getLocale().getLocale()).format(this.entry.getDate()), ", ", DateFormat.getTimeInstance().format(this.entry.getDate()))));
        } else {
            this.dateLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("DATE"), "-"));
        }
        this.podcastFeedLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("PODCAST_FEED"), this.entry.getPodcastFeed().getName()));
        this.downloadedLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("DOWNLOADED"), this.entry.isDownloaded() ? I18nUtils.getString("YES") : I18nUtils.getString("NO")));
        this.descriptionLabel.setText(PodcastFeedEntryPropertiesDialog.getHtmlFormatted(I18nUtils.getString("DESCRIPTION"), ""));
        this.descriptionTextArea.setText(this.entry.getDescription());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PodcastFeedEntryPropertiesDialog.this.descriptionTextArea.setCaretPosition(0);
            }
        });
    }
}

