/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import net.sourceforge.atunes.gui.views.controls.PopUpButton;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.CloseOtherPlaylistsAction;
import net.sourceforge.atunes.kernel.actions.ClosePlaylistAction;
import net.sourceforge.atunes.kernel.actions.CopyPlayListToDeviceAction;
import net.sourceforge.atunes.kernel.actions.NewPlayListAction;
import net.sourceforge.atunes.kernel.actions.RenamePlaylistAction;
import net.sourceforge.atunes.kernel.actions.SynchronizeDeviceWithPlayListAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListTableModel;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PlayListTabPanel
extends JPanel {
    private static final long serialVersionUID = 7382098268271937439L;
    public static final int TAB_HEIGHT = 26;
    private PopUpButton playListsPopUpButton;
    private JMenuItem newPlayListMenuItem;
    private JMenuItem arrangeColumnsMenuItem;
    private JTabbedPane playListTabbedPane;
    private JPopupMenu popupMenu;

    public PlayListTabPanel() {
        super(new BorderLayout());
        this.addContent();
        this.setPreferredSize(new Dimension(10, 26));
    }

    private void addContent() {
        this.playListsPopUpButton = new PopUpButton(I18nUtils.getString("PLAYLIST"), 4);
        this.newPlayListMenuItem = new JMenuItem(Actions.getAction(NewPlayListAction.class));
        this.arrangeColumnsMenuItem = new JMenuItem(I18nUtils.getString("ARRANGE_COLUMNS"));
        this.playListTabbedPane = new JTabbedPane();
        this.playListTabbedPane.setTabLayoutPolicy(1);
        new TabReorderer(this.playListTabbedPane).enableReordering(this.playListTabbedPane);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        jPanel.add((Component)this.playListsPopUpButton, gridBagConstraints);
        this.add((Component)jPanel, GuiUtils.getComponentOrientation().isLeftToRight() ? "West" : "East");
        this.add((Component)this.playListTabbedPane, "Center");
        this.playListTabbedPane.setPreferredSize(new Dimension(0, 26));
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(Actions.getAction(RenamePlaylistAction.class)));
        this.popupMenu.add(new JSeparator());
        this.popupMenu.add(new JMenuItem(Actions.getAction(CopyPlayListToDeviceAction.class)));
        this.popupMenu.add(new JMenuItem(Actions.getAction(SynchronizeDeviceWithPlayListAction.class)));
        this.popupMenu.add(new JSeparator());
        this.popupMenu.add(new JMenuItem(Actions.getAction(ClosePlaylistAction.class)));
        this.popupMenu.add(new JMenuItem(Actions.getAction(CloseOtherPlaylistsAction.class)));
        GuiUtils.applyComponentOrientation(this, this.popupMenu);
    }

    public void addFixedMenuItems() {
        this.playListsPopUpButton.add(this.newPlayListMenuItem);
        this.playListsPopUpButton.add(this.arrangeColumnsMenuItem);
        this.playListsPopUpButton.add(new JSeparator());
    }

    public JTabbedPane getPlayListTabbedPane() {
        return this.playListTabbedPane;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public PopUpButton getPlayListsPopUpButton() {
        return this.playListsPopUpButton;
    }

    public JMenuItem getArrangeColumnsMenuItem() {
        return this.arrangeColumnsMenuItem;
    }

    private static class SwitchPlayList
    implements Runnable {
        private int targetTabIndex;

        public SwitchPlayList(int n) {
            this.targetTabIndex = n;
        }

        @Override
        public void run() {
            PlayListHandler.getInstance().switchToPlaylist(this.targetTabIndex);
        }
    }

    public static class TabReorderer
    extends MouseInputAdapter {
        private JTabbedPane tabPane;
        private int draggedTabIndex;

        public TabReorderer(JTabbedPane jTabbedPane) {
            this.tabPane = jTabbedPane;
            this.draggedTabIndex = -1;
        }

        public void enableReordering(JTabbedPane jTabbedPane) {
            jTabbedPane.addMouseListener(this);
            jTabbedPane.addMouseMotionListener(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.draggedTabIndex = this.tabPane.getUI().tabForCoordinate(this.tabPane, mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.draggedTabIndex == -1) {
                return;
            }
            int n = this.tabPane.getUI().tabForCoordinate(this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && n != this.draggedTabIndex) {
                ControllerProxy.getInstance().getPlayListTabController().switchPlayListTabs(this.draggedTabIndex, n);
                PlayListHandler.getInstance().movePlaylistToPosition(this.draggedTabIndex, n);
                ((PlayListTableModel)GuiHandler.getInstance().getPlayListTable().getModel()).setVisiblePlayList(PlayListHandler.getInstance().getCurrentPlayList(true));
                ControllerProxy.getInstance().getPlayListTabController().forceSwitchTo(n);
                this.draggedTabIndex = -1;
                SwingUtilities.invokeLater(new SwitchPlayList(n));
            }
        }
    }
}

