/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel;

import java.util.Locale;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.LocaleBean;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.DateUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

final class LanguageSelector {
    private LanguageSelector() {
    }

    static void setLanguage() {
        LocaleBean localeBean = ApplicationState.getInstance().getLocale();
        Logger logger = new Logger();
        if (localeBean != null) {
            I18nUtils.setLocale(localeBean.getLocale());
            logger.info("START       ", StringUtils.getString("Setting language: ", localeBean.getLocale()));
        } else {
            logger.info("START       ", "Language not configured; using default language");
            I18nUtils.setLocale(null);
            ApplicationState.getInstance().setLocale(new LocaleBean(I18nUtils.getSelectedLocale()));
        }
        Locale locale = ApplicationState.getInstance().getLocale().getLocale();
        DateUtils.setLocale(locale);
        Locale.setDefault(locale);
    }
}

