/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.device.TransferToRepositoryProcess;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class CopyToRepositoryAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = 2416674807979541242L;

    CopyToRepositoryAction() {
        super(I18nUtils.getString("COPY_TO_REPOSITORY"), Images.getImage("export.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("COPY_TO_REPOSITORY"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        TransferToRepositoryProcess transferToRepositoryProcess = new TransferToRepositoryProcess(list);
        transferToRepositoryProcess.addProcessListener(new ImportProcessListener());
        transferToRepositoryProcess.execute();
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return !bl && !list.isEmpty();
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return !list.isEmpty();
    }

    private static class ImportProcessListener
    implements ProcessListener {
        private ImportProcessListener() {
        }

        @Override
        public void processCanceled() {
        }

        @Override
        public void processFinished(boolean bl) {
            SwingUtilities.invokeLater(new ImportProcessFinishedRunnable(bl));
        }

        private static final class ImportProcessFinishedRunnable
        implements Runnable {
            private final boolean ok;

            private ImportProcessFinishedRunnable(boolean bl) {
                this.ok = bl;
            }

            @Override
            public void run() {
                if (!this.ok) {
                    GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("ERRORS_IN_COPYING_PROCESS"));
                }
                RepositoryHandler.getInstance().refreshRepository();
            }
        }
    }
}

