/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public class ExtractPictureAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = -8618297820141610193L;

    ExtractPictureAction() {
        super(I18nUtils.getString("EXTRACT_PICTURE"), Images.getImage("exportPicture.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("EXTRACT_PICTURE"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        AudioFilePictureUtils.exportPicture(list.get(0), GuiHandler.getInstance().getFrame().getFrame());
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return list.size() == 1 && list.get(0) instanceof AudioFile && ((AudioFile)list.get(0)).hasInternalPicture();
    }
}

