/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public class KaraokeModeAction
extends AbstractAction {
    private static final long serialVersionUID = 1614471688413649087L;
    private Timer timer;

    KaraokeModeAction() {
        super(I18nUtils.getString("KARAOKE"), Images.getImage("karaoke.png"));
        this.putValue("ShortDescription", I18nUtils.getString("KARAOKE"));
        this.putValue("SwingSelectedKey", ApplicationState.getInstance().isKaraoke());
        this.timer = new Timer(1000, new ActionListener(){
            private boolean showWarning;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.showWarning) {
                    KaraokeModeAction.this.putValue("SmallIcon", Images.getImage("karaoke.png"));
                } else {
                    KaraokeModeAction.this.putValue("SmallIcon", Images.getImage("warning.png"));
                }
                this.showWarning = !this.showWarning;
            }
        });
        if (ApplicationState.getInstance().isKaraoke()) {
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ApplicationState.getInstance().setKaraoke((Boolean)this.getValue("SwingSelectedKey"));
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.putValue("SmallIcon", Images.getImage("karaoke.png"));
        } else {
            this.timer.start();
        }
    }
}

