/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public class MuteAction
extends AbstractAction {
    private static final long serialVersionUID = 306200192652324065L;

    MuteAction() {
        super(I18nUtils.getString("MUTE"));
        this.putValue("ShortDescription", I18nUtils.getString("MUTE"));
        this.putValue("SwingSelectedKey", ApplicationState.getInstance().isMuteEnabled());
        this.updateIcon();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            this.putValue("SwingSelectedKey", (Boolean)this.getValue("SwingSelectedKey") == false);
        }
        ApplicationState.getInstance().setMuteEnabled((Boolean)this.getValue("SwingSelectedKey"));
        PlayerHandler.getInstance().applyMuteState(ApplicationState.getInstance().isMuteEnabled());
        this.updateIcon();
    }

    public void updateIcon() {
        if (ApplicationState.getInstance().isMuteEnabled()) {
            this.putValue("SmallIcon", Images.getImage("volume-mute.png"));
        } else {
            int n = ApplicationState.getInstance().getVolume();
            if (n > 80) {
                this.putValue("SmallIcon", Images.getImage("volume-max.png"));
            } else if (n > 40) {
                this.putValue("SmallIcon", Images.getImage("volume-med.png"));
            } else if (n > 5) {
                this.putValue("SmallIcon", Images.getImage("volume-min.png"));
            } else {
                this.putValue("SmallIcon", Images.getImage("volume-zero.png"));
            }
        }
    }
}

