/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.DeviceNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.RepositoryNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.apache.commons.io.FileUtils;

public class RemoveFromDiskAction
extends AbstractAction {
    private static final long serialVersionUID = -6958409532399604195L;
    private Logger logger;

    public RemoveFromDiskAction() {
        super(I18nUtils.getString("REMOVE_FROM_DISK"), Images.getImage("delete.png"));
        this.putValue("ShortDescription", I18nUtils.getString("REMOVE_FROM_DISK"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("REMOVE_CONFIRMATION"), I18nUtils.getString("CONFIRMATION")) == 0) {
            if (NavigationHandler.getInstance().getCurrentView() instanceof PodcastNavigationView) {
                this.fromPodcastView();
            } else if ((NavigationHandler.getInstance().getCurrentView() instanceof RepositoryNavigationView || NavigationHandler.getInstance().getCurrentView() instanceof DeviceNavigationView) && NavigationHandler.getInstance().getCurrentViewMode() == NavigationController.ViewMode.FOLDER && ControllerProxy.getInstance().getNavigationController().getPopupMenuCaller() instanceof JTree) {
                this.fromRepositoryOrDeviceView();
            } else {
                this.fromOtherViews();
            }
        }
    }

    private void fromOtherViews() {
        List<AudioFile> list = ControllerProxy.getInstance().getNavigationController().getFilesSelectedInNavigator();
        RepositoryHandler.getInstance().remove(list);
        GuiHandler.getInstance().showIndeterminateProgressDialog(I18nUtils.getString("PLEASE_WAIT"));
        new DeleteFilesWorker(list).execute();
    }

    private void fromRepositoryOrDeviceView() {
        TreePath[] treePathArray = NavigationHandler.getInstance().getCurrentView().getTree().getSelectionPaths();
        final ArrayList<Folder> arrayList = new ArrayList<Folder>();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (!(object instanceof Folder)) continue;
                arrayList.add((Folder)object);
            }
        }
        RepositoryHandler.getInstance().removeFolders(arrayList);
        GuiHandler.getInstance().showIndeterminateProgressDialog(I18nUtils.getString("PLEASE_WAIT"));
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                for (Folder folder : arrayList) {
                    try {
                        FileUtils.deleteDirectory((File)folder.getFolderPath());
                        RemoveFromDiskAction.this.getLogger().info("REPOSITORY  ", StringUtils.getString("Removed folder ", folder));
                    }
                    catch (IOException iOException) {
                        RemoveFromDiskAction.this.getLogger().info("REPOSITORY  ", StringUtils.getString("Could not remove folder ", folder, iOException.getMessage()));
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                GuiHandler.getInstance().hideIndeterminateProgressDialog();
            }
        }.execute();
    }

    private void fromPodcastView() {
        int[] nArray = ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getSelectedRows();
        if (nArray.length > 0) {
            ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
            for (int n : nArray) {
                arrayList.add(((NavigationTableModel)ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getModel()).getAudioObjectAt(n));
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                PodcastFeedEntry podcastFeedEntry = (PodcastFeedEntry)arrayList.get(i);
                PodcastFeedHandler.getInstance().deleteDownloadedPodcastFeedEntry(podcastFeedEntry);
            }
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return !bl && !list.isEmpty();
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        if (NavigationHandler.getInstance().getCurrentView().equals(NavigationHandler.getInstance().getView(PodcastNavigationView.class))) {
            for (AudioObject audioObject : list) {
                if (((PodcastFeedEntry)audioObject).isDownloaded()) continue;
                return false;
            }
            return true;
        }
        return !list.isEmpty();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private static final class DeleteFilesWorker
    extends SwingWorker<Void, Void> {
        private final List<AudioFile> files;

        private DeleteFilesWorker(List<AudioFile> list) {
            this.files = list;
        }

        @Override
        protected Void doInBackground() {
            for (AudioFile audioFile : this.files) {
                File file = audioFile.getFile();
                if (file == null) continue;
                file.delete();
            }
            return null;
        }

        @Override
        protected void done() {
            GuiHandler.getInstance().hideIndeterminateProgressDialog();
        }
    }
}

