/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.utils.I18nUtils;

public class RenamePodcastFeedAction
extends AbstractAction {
    private static final long serialVersionUID = 8334487960720117561L;

    RenamePodcastFeedAction() {
        super(I18nUtils.getString("RENAME_PODCAST_FEED"), Images.getImage("editAlbum.png"));
        this.putValue("ShortDescription", I18nUtils.getString("RENAME_PODCAST_FEED"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getView(PodcastNavigationView.class).getTree().getSelectionPath();
        PodcastFeed podcastFeed = (PodcastFeed)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        String string = GuiHandler.getInstance().showInputDialog(I18nUtils.getString("RENAME_PODCAST_FEED"), podcastFeed.getName(), Images.getImage("rss_little.png").getImage());
        if (string != null) {
            podcastFeed.setName(string);
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return !bl && !list.isEmpty();
    }
}

