/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.RadioNavigationView;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.radio.RadioHandler;
import net.sourceforge.atunes.utils.I18nUtils;

public class RenameRadioAction
extends AbstractAction {
    private static final long serialVersionUID = -922076985505834816L;

    RenameRadioAction() {
        super(I18nUtils.getString("RENAME_RADIO"), Images.getImage("editAlbum.png"));
        this.putValue("ShortDescription", I18nUtils.getString("RENAME_RADIO"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getView(RadioNavigationView.class).getTree().getSelectionPath();
        Radio radio = (Radio)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        String string = GuiHandler.getInstance().showInputDialog(I18nUtils.getString("RENAME_RADIO"), radio.getName(), Images.getImage("radio_little.png").getImage());
        if (string != null) {
            RadioHandler.getInstance().setName(radio, string);
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (bl) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Radio) continue;
            return false;
        }
        return true;
    }
}

